/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import javax.annotation.Nullable;
import nc.block.NCBlock;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.validation.ValidationError;
import nc.render.BlockHighlightTracker;
import nc.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MultiblockBlockPartBase
extends NCBlock
implements ITileEntityProvider {
    protected static boolean keepInventory;

    public MultiblockBlockPartBase(String name, Material material, CreativeTabs tab) {
        super(name, material);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149647_a(tab);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    protected boolean rightClickOnPart(World world, BlockPos pos, EntityPlayer player) {
        return this.rightClickOnPart(world, pos, player, false);
    }

    protected boolean rightClickOnPart(World world, BlockPos pos, EntityPlayer player, boolean prioritiseGui) {
        TileEntity tile;
        if (!world.field_72995_K && player.func_184614_ca().func_190926_b() && (tile = world.func_175625_s(pos)) instanceof IMultiblockPart) {
            Object controller = ((IMultiblockPart)tile).getMultiblock();
            if (controller != null) {
                ValidationError e = ((MultiblockBase)controller).getLastError();
                if (e != null) {
                    e = e.updatedError(world);
                    player.func_145747_a(e.getChatMessage());
                    if (e.getErrorPos() != null) {
                        BlockHighlightTracker.sendPacket((EntityPlayerMP)player, e.getErrorPos(), 5000L);
                    }
                    return true;
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nuclearcraft.multiblock_validation.no_controller")));
                return true;
            }
        }
        return prioritiseGui;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof IInventory) {
            this.dropItems(world, pos, (IInventory)tileentity);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void dropItems(World world, BlockPos pos, IInventory tileentity) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public static abstract class Transparent
    extends MultiblockBlockPartBase {
        protected final boolean smartRender;

        public Transparent(String name, Material material, CreativeTabs tab, boolean smartRender) {
            super(name, material, tab);
            this.func_149711_c(1.5f);
            this.func_149752_b(10.0f);
            this.smartRender = smartRender;
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
            if (!this.smartRender) {
                return true;
            }
            IBlockState otherState = world.func_180495_p(pos.func_177972_a(side));
            Block block = otherState.func_177230_c();
            if (blockState != otherState) {
                return true;
            }
            return block == this ? false : super.func_176225_a(blockState, world, pos, side);
        }
    }
}

