/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.util;

import appeng.api.util.AEPartLocation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class WorldCoord {
    public int x;
    public int y;
    public int z;

    public WorldCoord(TileEntity s) {
        this(s.func_174877_v());
    }

    public WorldCoord(int _x, int _y, int _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public WorldCoord(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
    }

    public WorldCoord subtract(AEPartLocation direction, int length) {
        this.x -= direction.xOffset * length;
        this.y -= direction.yOffset * length;
        this.z -= direction.zOffset * length;
        return this;
    }

    public WorldCoord add(int _x, int _y, int _z) {
        this.x += _x;
        this.y += _y;
        this.z += _z;
        return this;
    }

    public WorldCoord subtract(int _x, int _y, int _z) {
        this.x -= _x;
        this.y -= _y;
        this.z -= _z;
        return this;
    }

    public WorldCoord multiple(int _x, int _y, int _z) {
        this.x *= _x;
        this.y *= _y;
        this.z *= _z;
        return this;
    }

    public WorldCoord divide(int _x, int _y, int _z) {
        this.x /= _x;
        this.y /= _y;
        this.z /= _z;
        return this;
    }

    public AEPartLocation directionTo(WorldCoord loc) {
        int ox = this.x - loc.x;
        int oy = this.y - loc.y;
        int oz = this.z - loc.z;
        int xlen = Math.abs(ox);
        int ylen = Math.abs(oy);
        int zlen = Math.abs(oz);
        if (loc.isEqual(this.copy().add(AEPartLocation.EAST, xlen))) {
            return AEPartLocation.EAST;
        }
        if (loc.isEqual(this.copy().add(AEPartLocation.WEST, xlen))) {
            return AEPartLocation.WEST;
        }
        if (loc.isEqual(this.copy().add(AEPartLocation.NORTH, zlen))) {
            return AEPartLocation.NORTH;
        }
        if (loc.isEqual(this.copy().add(AEPartLocation.SOUTH, zlen))) {
            return AEPartLocation.SOUTH;
        }
        if (loc.isEqual(this.copy().add(AEPartLocation.UP, ylen))) {
            return AEPartLocation.UP;
        }
        if (loc.isEqual(this.copy().add(AEPartLocation.DOWN, ylen))) {
            return AEPartLocation.DOWN;
        }
        return null;
    }

    public boolean isEqual(WorldCoord c) {
        return this.x == c.x && this.y == c.y && this.z == c.z;
    }

    public WorldCoord add(AEPartLocation direction, int length) {
        this.x += direction.xOffset * length;
        this.y += direction.yOffset * length;
        this.z += direction.zOffset * length;
        return this;
    }

    public WorldCoord copy() {
        return new WorldCoord(this.x, this.y, this.z);
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z;
    }

    public boolean equals(Object obj) {
        return obj instanceof WorldCoord && this.isEqual((WorldCoord)obj);
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", z=" + this.z;
    }
}

