/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseHelper;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.IngredientRenderer;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.ItemStack;

public class IngredientGridAll
implements IShowsRecipeFocuses,
IMouseHandler,
IGhostIngredientDragSource {
    private static final int NAVIGATION_HEIGHT = 20;
    private static int firstItemIndex = 0;
    private final IPaged pageDelegate;
    private final PageNavigation navigation;
    private final IngredientGrid ingredientGrid;
    private final IngredientFilter ingredientFilter;
    private Rectangle area = new Rectangle();
    private Set<Rectangle> guiExclusionAreas = Collections.emptySet();

    public IngredientGridAll(IngredientFilter ingredientFilter) {
        this.ingredientGrid = new IngredientGrid();
        this.ingredientFilter = ingredientFilter;
        this.pageDelegate = new IngredientGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false);
    }

    public void updateLayout(boolean filterChanged) {
        if (filterChanged) {
            firstItemIndex = 0;
        }
        this.ingredientGrid.updateLayout(this.guiExclusionAreas);
        List<IIngredientListElement> ingredientList = this.ingredientFilter.getIngredientList();
        this.ingredientGrid.guiIngredientSlots.set(firstItemIndex, ingredientList);
        this.navigation.updatePageState();
    }

    public void updateBounds(Rectangle availableArea, int minWidth) {
        Rectangle boundsWithoutNavigation = new Rectangle(availableArea.x, availableArea.y + 20, availableArea.width, availableArea.height - 20);
        this.ingredientGrid.updateBounds(boundsWithoutNavigation, minWidth, this.guiExclusionAreas);
        Rectangle displayArea = this.ingredientGrid.getArea();
        Rectangle navigationArea = new Rectangle(displayArea.x, availableArea.y, displayArea.width, 20);
        this.navigation.updateBounds(navigationArea);
        this.area = displayArea.union(navigationArea);
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.updateGuiExclusionAreas()) {
            this.updateLayout(false);
        }
        this.ingredientGrid.draw(minecraft, mouseX, mouseY);
        this.navigation.draw(minecraft, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        this.ingredientGrid.drawTooltips(minecraft, mouseX, mouseY);
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY) && !MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        return !MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY) && (this.ingredientGrid.handleMouseClicked(mouseX, mouseY) || this.navigation.handleMouseClickedButtons(mouseX, mouseY));
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (scrollDelta < 0) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.pageDelegate.previousPage();
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int keyCode) {
        if (KeyBindings.nextPage.isActiveAndMatches(keyCode)) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (KeyBindings.previousPage.isActiveAndMatches(keyCode)) {
            this.pageDelegate.previousPage();
            return true;
        }
        return this.checkHotbarKeys(keyCode);
    }

    protected boolean checkHotbarKeys(int keyCode) {
        int mouseY;
        int mouseX;
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (Config.isCheatItemsEnabled() && guiScreen != null && !(guiScreen instanceof RecipesGui) && this.isMouseOver(mouseX = MouseHelper.getX(), mouseY = MouseHelper.getY())) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
                if (!gameSettings.field_151456_ac[hotbarSlot].isActiveAndMatches(keyCode)) continue;
                IClickedIngredient<?> ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY);
                if (ingredientUnderMouse != null) {
                    ItemStack itemStack = ingredientUnderMouse.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.setHotbarStack(itemStack, hotbarSlot);
                    }
                    ingredientUnderMouse.onClickHandled();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        return this.ingredientGrid.getElementUnderMouse();
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.ingredientGrid.canSetFocusWithMouse();
    }

    public boolean updateGuiExclusionAreas() {
        Set<Rectangle> guiAreas = IngredientGridAll.getGuiAreas();
        if (!guiAreas.equals(this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas;
            return true;
        }
        return false;
    }

    public List<IIngredientListElement> getVisibleElements() {
        ArrayList<IIngredientListElement> visibleElements = new ArrayList<IIngredientListElement>();
        for (IngredientListSlot slot : this.ingredientGrid.guiIngredientSlots.getAllGuiIngredientSlots()) {
            IngredientRenderer renderer = slot.getIngredientRenderer();
            if (renderer == null) continue;
            visibleElements.add(renderer.getElement());
        }
        return visibleElements;
    }

    private static Set<Rectangle> getGuiAreas() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)currentScreen;
            JeiRuntime jeiRuntime = Internal.getRuntime();
            if (jeiRuntime != null) {
                HashSet<Rectangle> allGuiExtraAreas = new HashSet<Rectangle>();
                List<IAdvancedGuiHandler<GuiContainer>> activeAdvancedGuiHandlers = jeiRuntime.getActiveAdvancedGuiHandlers(guiContainer);
                for (IAdvancedGuiHandler<GuiContainer> advancedGuiHandler : activeAdvancedGuiHandlers) {
                    List<Rectangle> guiExtraAreas = advancedGuiHandler.getGuiExtraAreas(guiContainer);
                    if (guiExtraAreas == null) continue;
                    allGuiExtraAreas.addAll(guiExtraAreas);
                }
                return allGuiExtraAreas;
            }
        }
        return Collections.emptySet();
    }

    private class IngredientGridPaged
    implements IPaged {
        private IngredientGridPaged() {
        }

        @Override
        public boolean nextPage() {
            int itemsCount = IngredientGridAll.this.ingredientFilter.size();
            if (itemsCount > 0) {
                firstItemIndex = firstItemIndex + IngredientGridAll.this.ingredientGrid.size();
                if (firstItemIndex >= itemsCount) {
                    firstItemIndex = 0;
                }
                IngredientGridAll.this.updateLayout(false);
                return true;
            }
            firstItemIndex = 0;
            IngredientGridAll.this.updateLayout(false);
            return false;
        }

        @Override
        public boolean previousPage() {
            int itemsPerPage = IngredientGridAll.this.ingredientGrid.size();
            if (itemsPerPage == 0) {
                firstItemIndex = 0;
                IngredientGridAll.this.updateLayout(false);
                return false;
            }
            int itemsCount = IngredientGridAll.this.ingredientFilter.size();
            int pageNum = firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            firstItemIndex = itemsPerPage * pageNum;
            if (firstItemIndex > 0 && firstItemIndex == itemsCount) {
                firstItemIndex = itemsPerPage * --pageNum;
            }
            IngredientGridAll.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            int itemsPerPage = IngredientGridAll.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridAll.this.ingredientFilter.size() > itemsPerPage;
        }

        @Override
        public boolean hasPrevious() {
            int itemsPerPage = IngredientGridAll.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridAll.this.ingredientFilter.size() > itemsPerPage;
        }

        @Override
        public int getPageCount() {
            int itemCount = IngredientGridAll.this.ingredientFilter.size();
            int stacksPerPage = IngredientGridAll.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        @Override
        public int getPageNumber() {
            int stacksPerPage = IngredientGridAll.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            return firstItemIndex / stacksPerPage;
        }
    }
}

