/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class ReactorFuelRodsLayout {
    public static final ReactorFuelRodsLayout DEFAULT = new ReactorFuelRodsLayout();
    private final EnumFacing _cachedOutwardFacing;
    private final int _rodLength;
    private static final EnumFacing[] RADIATE_DIRECTIONS_X_AXIS = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH};
    private static final EnumFacing[] RADIATE_DIRECTIONS_Y_AXIS = EnumFacing.field_176754_o;
    private static final EnumFacing[] RADIATE_DIRECTIONS_Z_AXIS = new EnumFacing[]{EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.UP};

    public ReactorFuelRodsLayout(@Nonnull MultiblockReactor reactor) {
        this._cachedOutwardFacing = reactor.getControlRodByIndex(0).getOutwardFacing();
        BlockPos minCoord = reactor.getMinimumCoord();
        BlockPos maxCoord = reactor.getMaximumCoord();
        switch (this.getAxis()) {
            default: {
                this._rodLength = Math.max(1, maxCoord.func_177958_n() - minCoord.func_177958_n() - 1);
                break;
            }
            case Y: {
                this._rodLength = Math.max(1, maxCoord.func_177956_o() - minCoord.func_177956_o() - 1);
                break;
            }
            case Z: {
                this._rodLength = Math.max(1, maxCoord.func_177952_p() - minCoord.func_177952_p() - 1);
            }
        }
    }

    private ReactorFuelRodsLayout() {
        this._cachedOutwardFacing = EnumFacing.UP;
        this._rodLength = 1;
    }

    public EnumFacing.Axis getAxis() {
        return this._cachedOutwardFacing.func_176740_k();
    }

    public EnumFacing[] getRadiateDirections() {
        switch (this.getAxis()) {
            case X: {
                return RADIATE_DIRECTIONS_X_AXIS;
            }
            default: {
                return RADIATE_DIRECTIONS_Y_AXIS;
            }
            case Z: 
        }
        return RADIATE_DIRECTIONS_Z_AXIS;
    }

    public int getRodLength() {
        return this._rodLength;
    }

    public void updateFuelData(@Nonnull FuelContainer fuelData, int fuelRodsTotalCount) {
    }

    public void updateFuelRodsOcclusion(@Nonnull Set<TileEntityReactorFuelRod> fuelRods) {
    }
}

