/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wpt.sync;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import p455w0rd.wpt.sync.WPTPacket;
import p455w0rd.wpt.sync.packets.PacketCraftRequest;
import p455w0rd.wpt.sync.packets.PacketInventoryAction;
import p455w0rd.wpt.sync.packets.PacketJEIPatternRecipe;
import p455w0rd.wpt.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wpt.sync.packets.PacketOpenGui;
import p455w0rd.wpt.sync.packets.PacketPatternSlot;
import p455w0rd.wpt.sync.packets.PacketSwitchGuis;
import p455w0rd.wpt.sync.packets.PacketTargetItemStack;
import p455w0rd.wpt.sync.packets.PacketValueConfig;

public class WPTPacketHandlerBase {
    private static final Map<Class<? extends WPTPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends WPTPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_JEI_PATTERN_RECIPE(PacketJEIPatternRecipe.class),
        PACKET_CREAFT_REQUEST(PacketCraftRequest.class),
        PACKET_TARGET_ITEMSTACK(PacketTargetItemStack.class),
        PACKET_SWITCH_GUIS(PacketSwitchGuis.class),
        PACKET_INVENTORY_UPDATE(PacketMEInventoryUpdate.class),
        PACKET_PATTERN_SLOT(PacketPatternSlot.class),
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_OPENWIRELESSTERM(PacketOpenGui.class);

        private final Class<? extends WPTPacket> packetClass;
        private final Constructor<? extends WPTPacket> packetConstructor;

        private PacketTypes(Class<? extends WPTPacket> c) {
            this.packetClass = c;
            Constructor<? extends WPTPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends WPTPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public WPTPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

