/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks.tileentity;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.ITankListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import trinsdar.ic2c_extras.blocks.container.ContainerFluidCanningMachine;
import trinsdar.ic2c_extras.blocks.tileentity.base.TileEntityFluidCannerBase;
import trinsdar.ic2c_extras.util.GuiMachine;
import trinsdar.ic2c_extras.util.recipelists.FluidCanningRecipeList;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

public class TileEntityFluidCanningMachine
extends TileEntityFluidCannerBase
implements ITankListener,
IClickable {
    public static FluidCanningRecipeList fluidCanning = new FluidCanningRecipeList("fluidCanning");

    public TileEntityFluidCanningMachine() {
        super(3, 4, 1, 400, 32);
        slotInput = 0;
        slotOutput = 2;
        this.inputTank.addListener((ITankListener)this);
        this.outputTank.addListener((ITankListener)this);
        this.inputTank.setCanFill(true);
        this.outputTank.setCanFill(true);
        this.inputTank.setCanDrain(true);
        this.outputTank.setCanDrain(true);
        this.addGuiFields(new String[]{"inputTank", "outputTank"});
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{1});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{slotInput});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{slotOutput});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{slotOutput});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{slotInput});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{1});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{1});
        handler.registerSlotType(SlotType.Fuel, new int[]{1});
        handler.registerSlotType(SlotType.Input, new int[]{slotInput});
        handler.registerSlotType(SlotType.Output, new int[]{slotOutput});
    }

    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField((TileEntity)this, "inputTank");
        this.getNetwork().updateTileGuiField((TileEntity)this, "outputTank");
        this.setStackInSlot(slotInput, (ItemStack)this.inventory.get(slotInput));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt.func_74775_l("inputTank"));
        this.outputTank.readFromNBT(nbt.func_74775_l("outputTank"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inputTank.writeToNBT(this.getTag(nbt, "inputTank"));
        this.outputTank.writeToNBT(this.getTag(nbt, "outputTank"));
        return nbt;
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{slotInput};
    }

    @Override
    public IFilter[] getInputFilters(int[] slots) {
        return new IFilter[]{new MachineFilter((IMachine)this)};
    }

    @Override
    public boolean isRecipeSlot(int slot) {
        return true;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{slotOutput};
    }

    @Override
    public FluidCanningRecipeList getRecipeList() {
        return fluidCanning;
    }

    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return new LinkedHashSet<IMachineUpgradeItem.UpgradeType>(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerFluidCanningMachine(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiMachine.FluidCanningGui.class;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.fluidCanningMachine;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public EnumFacing left() {
        if (this.getFacing() == EnumFacing.NORTH) {
            return EnumFacing.EAST;
        }
        if (this.getFacing() == EnumFacing.WEST) {
            return EnumFacing.NORTH;
        }
        if (this.getFacing() == EnumFacing.SOUTH) {
            return EnumFacing.WEST;
        }
        if (this.getFacing() == EnumFacing.EAST) {
            return EnumFacing.SOUTH;
        }
        return this.getFacing();
    }

    public EnumFacing right() {
        if (this.getFacing() == EnumFacing.NORTH) {
            return EnumFacing.WEST;
        }
        if (this.getFacing() == EnumFacing.WEST) {
            return EnumFacing.SOUTH;
        }
        if (this.getFacing() == EnumFacing.SOUTH) {
            return EnumFacing.EAST;
        }
        if (this.getFacing() == EnumFacing.EAST) {
            return EnumFacing.NORTH;
        }
        return this.getFacing();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP || facing == this.left()) {
                return (T)this.inputTank;
            }
            if (facing == EnumFacing.DOWN || facing == this.right()) {
                return (T)this.outputTank;
            }
            return (T)super.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public ResourceLocation getGuiTexture() {
        return Ic2cExtrasResourceLocations.fluidCanningMachine;
    }

    public static void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output) {
        TileEntityFluidCanningMachine.addFillingRecipe(input, inputFluid, new MachineOutput(null, new ItemStack[]{output}));
    }

    public static void addEmptyingRecipe(IRecipeInput input, ItemStack output, FluidStack outputFluid) {
        TileEntityFluidCanningMachine.addEmptyingRecipe(input, new MachineOutput(null, new ItemStack[]{output}), outputFluid);
    }

    public static void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, ItemStack output, FluidStack outputFluid) {
        TileEntityFluidCanningMachine.addEnrichingRecipe(input, inputFluid, new MachineOutput(null, new ItemStack[]{output}), outputFluid);
    }

    public static void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, MachineOutput output) {
        fluidCanning.addFillingRecipe(input, inputFluid, output, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(output), (String)("filling_" + ((ItemStack)output.getAllOutputs().get(0)).func_77977_a())));
    }

    public static void addEmptyingRecipe(IRecipeInput input, MachineOutput output, FluidStack outputFluid) {
        fluidCanning.addEmptyingRecipe(input, output, outputFluid, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(output), (String)("emptying_" + ((ItemStack)output.getAllOutputs().get(0)).func_77977_a())));
    }

    public static void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, MachineOutput output, FluidStack outputFluid) {
        fluidCanning.addEnrichingRecipe(input, inputFluid, output, outputFluid, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(output), (String)("enriching_" + ((ItemStack)output.getAllOutputs().get(0)).func_77977_a())));
    }

    public static void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, FluidStack outputFluid) {
        fluidCanning.addEnrichingRecipe(input, inputFluid, outputFluid, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(outputFluid), (String)("enriching_" + outputFluid.getFluid().getUnlocalizedName())));
    }

    public boolean hasRightClick() {
        return true;
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing enumFacing, Side side) {
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b()) {
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.inputTank, (int)(this.inputTank.getCapacity() - this.inputTank.getFluidAmount()), (EntityPlayer)player, (boolean)true);
            if (result.isSuccess()) {
                playerStack.func_190918_g(1);
                ItemStack resultStack = result.getResult();
                if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                return true;
            }
            FluidActionResult result2 = FluidUtil.tryFillContainer((ItemStack)playerStack, (IFluidHandler)this.outputTank, (int)1000, (EntityPlayer)player, (boolean)true);
            if (result.isSuccess()) {
                playerStack.func_190918_g(1);
                ItemStack resultStack = result2.getResult();
                if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                    player.func_71019_a(resultStack, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hasLeftClick() {
        return false;
    }

    public void onLeftClick(EntityPlayer entityPlayer, Side side) {
    }
}

