/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import thaumcraft.common.lib.SoundsTC;

public class ItemCleaningTalisman
extends TTItem
implements IBauble {
    public static final String TAG_STATUS = "status";

    public ItemCleaningTalisman() {
        super("cleaning_talisman");
        this.func_185043_a(new ResourceLocation("thaumictinkerer", TAG_STATUS), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
                return ItemCleaningTalisman.getStatus(itemStack) ? 1.0f : 0.0f;
            }
        });
        this.func_77656_e(TTConfig.talismanUses);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack current = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            ItemCleaningTalisman.flipEnabled(current);
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.MASTER, 0.3f, 0.1f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)current);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private static void flipEnabled(ItemStack itemStack) {
        ItemNBTHelper.setBool(itemStack, TAG_STATUS, !ItemNBTHelper.getBool(itemStack, TAG_STATUS, false));
    }

    public static boolean getStatus(ItemStack itemStack) {
        return ItemNBTHelper.getBool(itemStack, TAG_STATUS, false);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (ItemCleaningTalisman.getStatus(stack)) {
            tooltip.add(ThaumicTinkerer.proxy.localize("ttmisc.cleaning_talisman.active", new Object[0]));
        } else {
            tooltip.add(ThaumicTinkerer.proxy.localize("ttmisc.cleaning_talisman.inactive", new Object[0]));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        World world = player.field_70170_p;
        if (ItemCleaningTalisman.getStatus(itemstack) && !world.field_72995_K && player.field_70173_aa % 20 == 0 && player instanceof EntityPlayer) {
            boolean removed = false;
            Collection effects = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
                removed = true;
            } else {
                for (PotionEffect effect : effects) {
                    Potion potion = effect.func_188419_a();
                    if (!potion.func_76398_f()) continue;
                    player.func_184589_d(potion);
                    removed = true;
                    break;
                }
            }
            if (removed) {
                itemstack.func_77972_a(1, player);
                world.func_184133_a((EntityPlayer)player, player.func_180425_c(), SoundsTC.wand, SoundCategory.MASTER, 0.3f, 0.1f);
            }
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

