/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common;

import c4.conarm.integrations.tinkertoolleveling.ConfigSyncLevelingPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;

@Config(modid="conarm")
public class ConfigHandler {
    @Config.Name(value="Spawn With Book")
    @Config.Comment(value={"Set to true to give an Armory Book to players who enter a world for the first time"})
    public static boolean spawnWithBook = true;
    @Config.Name(value="Compact GUI")
    @Config.Comment(value={"Set to true to disable the armor preview panel in the Armor Station/Forge GUI"})
    public static boolean compactView = false;
    @Config.Name(value="Bouncy Trait Uses Durability")
    @Config.Comment(value={"Set to true to have the Bouncy trait use durability for each bounce"})
    public static boolean bounceDurability = true;
    public static final Leveling leveling = new Leveling();

    @Mod.EventBusSubscriber(modid="conarm")
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (evt.getModID().equals("conarm")) {
                ConfigManager.sync((String)"conarm", (Config.Type)Config.Type.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
            ConfigSyncLevelingPacket sync = new ConfigSyncLevelingPacket(ConfigHandler.leveling.newArmorMinModifiers, ConfigHandler.leveling.maximumLevels, ConfigHandler.leveling.baseXP, ConfigHandler.leveling.levelMultiplier);
            TinkerNetwork.sendTo((AbstractPacket)sync, (EntityPlayerMP)((EntityPlayerMP)evt.player));
        }
    }

    public static class Leveling {
        @Config.Name(value="Starting Modifier Amount")
        @Config.Comment(value={"Reduces the amount of modifiers a newly built armor gets if the value is lower than the regular amount of modifiers the armor would have."})
        @Config.RequiresWorldRestart
        public int newArmorMinModifiers = 3;
        @Config.Name(value="Maximum Levels")
        @Config.Comment(value={"Maximum achievable levels. If set to 0 or lower there is no upper limit."})
        @Config.RequiresWorldRestart
        public int maximumLevels = -1;
        @Config.Name(value="Base XP Requirement")
        @Config.Comment(value={"Base XP needed for armor"})
        @Config.RequiresWorldRestart
        public int baseXP = 100;
        @Config.Name(value="Leveling Multiplier")
        @Config.Comment(value={"How much to multiply the experience needed for each level"})
        @Config.RequiresWorldRestart
        public float levelMultiplier = 2.0f;
    }
}

