/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014JH\u0010\u0015\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ6\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lal132/alib/utils/RenderUtils;", "", "()V", "BLOCK_TEX", "Lnet/minecraft/util/ResourceLocation;", "kotlin.jvm.PlatformType", "getBLOCK_TEX", "()Lnet/minecraft/util/ResourceLocation;", "bindBlockTexture", "", "bindTexture", "string", "", "tex", "engine", "Lnet/minecraft/client/renderer/texture/TextureManager;", "getStillTexture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "Lnet/minecraftforge/fluids/FluidStack;", "renderGuiTank", "capacity", "", "amount", "x", "", "y", "zLevel", "width", "height", "tank", "Lnet/minecraftforge/fluids/FluidTank;", "alib"})
public final class RenderUtils {
    private static final ResourceLocation BLOCK_TEX;
    public static final RenderUtils INSTANCE;

    public final ResourceLocation getBLOCK_TEX() {
        return BLOCK_TEX;
    }

    @NotNull
    public final TextureManager engine() {
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        Intrinsics.checkExpressionValueIsNotNull((Object)textureManager, (String)"Minecraft.getMinecraft().renderEngine");
        return textureManager;
    }

    public final void bindBlockTexture() {
        this.engine().func_110577_a(BLOCK_TEX);
    }

    public final void bindTexture(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        this.engine().func_110577_a(new ResourceLocation(string));
    }

    public final void bindTexture(@NotNull ResourceLocation tex) {
        Intrinsics.checkParameterIsNotNull((Object)tex, (String)"tex");
        this.engine().func_110577_a(tex);
    }

    @Nullable
    public final TextureAtlasSprite getStillTexture(@Nullable FluidStack fluid) {
        FluidStack fluidStack = fluid;
        if (fluidStack != null && (fluidStack = fluidStack.getFluid()) != null) {
            FluidStack fluidStack2;
            FluidStack it = fluidStack2 = fluidStack;
            return INSTANCE.getStillTexture((Fluid)it);
        }
        return null;
    }

    @Nullable
    public final TextureAtlasSprite getStillTexture(@NotNull Fluid fluid) {
        Intrinsics.checkParameterIsNotNull((Object)fluid, (String)"fluid");
        ResourceLocation resourceLocation = fluid.getStill();
        if (resourceLocation == null) {
            return null;
        }
        ResourceLocation iconKey = resourceLocation;
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        return minecraft.func_147117_R().getTextureExtry(iconKey.toString());
    }

    public final void renderGuiTank(@NotNull FluidTank tank, double x, double y, double zLevel, double width, double height) {
        Intrinsics.checkParameterIsNotNull((Object)tank, (String)"tank");
        this.renderGuiTank(tank.getFluid(), tank.getCapacity(), tank.getFluidAmount(), x, y, zLevel, width, height);
    }

    public final void renderGuiTank(@Nullable FluidStack fluid, int capacity, int amount, double x, double y, double zLevel, double width, double height) {
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            return;
        }
        TextureAtlasSprite textureAtlasSprite = this.getStillTexture(fluid);
        if (textureAtlasSprite == null) {
            return;
        }
        TextureAtlasSprite icon = textureAtlasSprite;
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)capacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        INSTANCE.bindBlockTexture();
        int color = fluid.getFluid().getColor(fluid);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GlStateManager.func_179147_l();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                Tessellator tessellator;
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
                Intrinsics.checkExpressionValueIsNotNull((Object)tessellator2, (String)"tessellator");
                BufferBuilder tes = tessellator2.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)drawHeight / (double)16.0f).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / (double)16.0f, minV + (maxV - minV) * (double)drawHeight / (double)16.0f).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, 0.0).func_187315_a(minU + (maxU - minU) * (double)drawWidth / (double)16.0f, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, 0.0).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.func_179084_k();
    }

    private RenderUtils() {
    }

    static {
        RenderUtils renderUtils;
        INSTANCE = renderUtils = new RenderUtils();
        BLOCK_TEX = TextureMap.field_110575_b;
    }
}

