/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.thaumcraft;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IArcaneWorkbench;
import thaumcraft.api.items.IVisDiscountGear;
import thaumcraft.api.potions.PotionVisExhaust;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumicenergistics.container.DummyContainer;

public class TCCraftingManager {
    public static IArcaneRecipe findArcaneRecipe(IItemHandler handler, EntityPlayer player) {
        ArcaneInventoryCrafting inventory = TCCraftingManager.getInvFromItemHandler(handler);
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)player.field_70170_p);
        return recipe instanceof IArcaneRecipe && ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{((IArcaneRecipe)recipe).getResearch()}) ? (IArcaneRecipe)recipe : null;
    }

    public static ItemStack getCraftingResult(IItemHandler handler, IArcaneRecipe recipe) {
        return recipe.func_77572_b((InventoryCrafting)TCCraftingManager.getInvFromItemHandler(handler));
    }

    public static ArcaneInventoryCrafting getInvFromItemHandler(IItemHandler handler) {
        ArcaneInventoryCrafting inventory = new ArcaneInventoryCrafting();
        for (int i = 0; i < handler.getSlots(); ++i) {
            inventory.func_70299_a(i, handler.getStackInSlot(i).func_77946_l());
        }
        return inventory;
    }

    public static float getDiscount(EntityPlayer player) {
        if (player == null) {
            return 0.0f;
        }
        int discount = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(36 + i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IVisDiscountGear)) continue;
            IVisDiscountGear gear = (IVisDiscountGear)stack.func_77973_b();
            discount += gear.getVisDiscount(stack, player);
        }
        int level1 = 0;
        int level2 = 0;
        if (player.func_70644_a(PotionVisExhaust.instance)) {
            level1 = Objects.requireNonNull(player.func_70660_b(PotionVisExhaust.instance)).func_76458_c();
        }
        if (player.func_70644_a(PotionInfectiousVisExhaust.instance)) {
            level2 = Objects.requireNonNull(player.func_70660_b(PotionInfectiousVisExhaust.instance)).func_76458_c();
        }
        if (level1 > 0 || level2 > 0) {
            discount -= (Math.max(level1, level2) + 1) * 10;
        }
        return (float)discount / 100.0f;
    }

    private static class ArcaneInventoryCrafting
    extends InventoryCrafting
    implements IArcaneWorkbench {
        public ArcaneInventoryCrafting() {
            super((Container)new DummyContainer(), 5, 3);
        }
    }
}

