/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine;

import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.machine.high.TileEntityElectricEnchanter;
import ic2.core.block.machine.high.TileEntityMassFabricator;
import ic2.core.block.machine.high.TileEntityPlasmafier;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.block.machine.high.TileEntityTeleporterHub;
import ic2.core.block.machine.high.TileEntityTerraformer;
import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.block.render.model.PlasmafierModel;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHVMachine
extends BlockMultiID
implements IBootable,
ICustomModeledBlock {
    public BlockHVMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setUnlocalizedName(Ic2BlockLang.machinesHV);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2Items.terraformer = new ItemStack((Block)this, 1, 0);
        Ic2Items.massfabricator = new ItemStack((Block)this, 1, 1);
        Ic2Items.teleporter = new ItemStack((Block)this, 1, 2);
        Ic2Items.uraniumEnricher = new ItemStack((Block)this, 1, 3);
        Ic2Items.electricEnchanter = new ItemStack((Block)this, 1, 4);
        Ic2Items.plasmafier = new ItemStack((Block)this, 1, 5);
        Ic2Items.teleporterHub = new ItemStack((Block)this, 1, 6);
        Ic2States.terraformer = this.func_176203_a(0);
        Ic2States.massfabricator = this.func_176203_a(1);
        Ic2States.teleporter = this.func_176203_a(2);
        Ic2States.uraniumEnricher = this.func_176203_a(3);
        Ic2States.electricEnchanter = this.func_176203_a(4);
        Ic2States.plasmafier = this.func_176203_a(5);
        Ic2States.teleporterHub = this.func_176203_a(6);
    }

    @Override
    public List<IBlockState> getValidStates() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (Integer meta : this.getValidMetas()) {
            if (meta == 5) continue;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
            }
        }
        return states;
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (Integer meta : this.getValidMetas()) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)meta).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
            }
        }
        return states;
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        if (stack.func_77960_j() == 2) {
            return this.func_176203_a(2).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.UP);
        }
        return super.getStateFromStack(stack);
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityTerraformer();
            }
            case 1: {
                return new TileEntityMassFabricator();
            }
            case 2: {
                return new TileEntityTeleporter();
            }
            case 3: {
                return new TileEntityUraniumEnricher();
            }
            case 4: {
                return new TileEntityElectricEnchanter();
            }
            case 5: {
                return new TileEntityPlasmafier();
            }
            case 6: {
                return new TileEntityTeleporterHub();
            }
        }
        return new TileEntityBlock();
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return meta == 2 || meta == 1;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        if (this.func_176201_c(state) == 5) {
            return false;
        }
        return super.func_149686_d(state);
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6);
    }

    @Override
    public EnumFacing getDefaultPlacementFacing(IBlockState state, EntityLivingBase placer) {
        if (this.func_176201_c(state) == 2) {
            return EnumFacing.UP;
        }
        return super.getDefaultPlacementFacing(state, placer);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Ic2Items.advMachine.func_77973_b();
    }

    @Deprecated
    public boolean func_149710_n(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta == 4 || meta == 5) {
            return true;
        }
        return super.func_149710_n(state);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (this.func_176201_c(state) == 5) {
            return layer == BlockRenderLayer.CUTOUT;
        }
        return super.canRenderInLayer(state, layer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures("bmach_hv");
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
            states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        }
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new PlasmafierModel(this, state);
    }
}

