/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.core.IC2;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.obj.IMetaSoundBlock;
import ic2.core.util.obj.IRareBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockRare
extends ItemBlock {
    public LocaleComp name = Ic2Lang.nullKey;

    public ItemBlockRare(Block block) {
        super(block);
    }

    public int func_77647_b(int damage) {
        if (!this.func_77614_k()) {
            return 0;
        }
        return damage;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.func_179223_d() instanceof IRareBlock) {
            return ((IRareBlock)this.func_179223_d()).getRarity(stack);
        }
        return super.func_77613_e(stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(this.field_150939_a, pos, false, facing, (Entity)null)) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                if (IC2.platform.isRendering()) {
                    iblockstate1 = worldIn.func_180495_p(pos);
                    SoundType soundtype = this.getSound(iblockstate1);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            ItemBlockRare.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            return true;
        }
        return false;
    }

    public SoundType getSound(IBlockState state) {
        SoundType type;
        if (state.func_177230_c() instanceof IMetaSoundBlock && (type = ((IMetaSoundBlock)state.func_177230_c()).getSoundFromState(state)) != null) {
            return type;
        }
        return this.func_179223_d().func_185467_w();
    }

    public LocaleComp getLangComponent() {
        return this.name;
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getLangComponent();
    }

    public Item setUnlocalizedName(LocaleComp component) {
        this.name = component;
        return super.func_77655_b(component.getUnlocalized());
    }

    public Item func_77655_b(String unlocalizedName) {
        this.name = new LangComponentHolder.LocaleItemComp("item." + unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    public String func_77658_a() {
        return this.getLangComponent().getUnlocalized();
    }

    public String func_77667_c(ItemStack stack) {
        return this.getLangComponent(stack).getUnlocalized();
    }

    public String func_77657_g(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }
}

