/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.events;

import ic2.core.IC2;
import ic2.core.block.resources.WorldGenRubberTree;
import ic2.core.platform.config.IC2Config;
import ic2.core.platform.registry.Ic2States;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class IC2WorldGenerator
implements IWorldGenerator {
    public static IC2WorldGenerator instance = new IC2WorldGenerator();
    boolean configLoaded = false;
    boolean genRubber;
    boolean genCopper;
    boolean genTin;
    boolean genUran;
    boolean genSilver;
    float oreDensity;

    public void updateConfig() {
        IC2Config config = IC2.config;
        this.genRubber = config.getFlag("WorldGenTreeRubber");
        this.genCopper = config.getFlag("WorldGenOreCopper");
        this.genTin = config.getFlag("WorldGenOreTin");
        this.genSilver = config.getFlag("WorldGenOreSilver");
        this.genUran = config.getFlag("WorldGenOreUranium");
        this.oreDensity = config.getFloat("oreDensityFactor");
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int y;
        int x;
        int n;
        int count;
        int baseCount;
        if (!this.configLoaded) {
            this.configLoaded = true;
            this.updateConfig();
        }
        if (this.genRubber) {
            Biome biomegenbase = world.func_180494_b(new BlockPos(chunkX * 16 + 16, 128, chunkZ * 16 + 16));
            int rubbertrees = 0;
            if (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
                rubbertrees += random.nextInt(3);
            }
            if (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                rubbertrees += random.nextInt(5) + 1;
            }
            if (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                rubbertrees += random.nextInt(10) + 5;
            }
            if (random.nextInt(100) + 1 <= rubbertrees * 2) {
                new WorldGenRubberTree(rubbertrees).func_180709_b(world, random, new BlockPos(chunkX * 16 + random.nextInt(16), 128, chunkZ * 16 + random.nextInt(16)));
            }
        }
        int baseScale = (int)((float)Math.round(world.field_73011_w.func_76557_i() + 1) * this.oreDensity);
        if (this.genCopper) {
            baseCount = 15 * baseScale / 64;
            count = (int)Math.round(random.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(40 * baseScale / 64) + random.nextInt(20 * baseScale / 64) + 10 * baseScale / 64;
                z = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(Ic2States.copperOre, 10).func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (this.genTin) {
            baseCount = 25 * baseScale / 64;
            count = (int)Math.round(random.nextGaussian() * Math.sqrt(baseCount) + (double)baseCount);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(40 * baseScale / 64);
                z = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(Ic2States.tinOre, 6).func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
        if (this.genUran) {
            Biome biomegenbase = world.func_180494_b(new BlockPos(chunkX * 16 + 16, 128, chunkZ * 16 + 16));
            int baseCount2 = 20 * baseScale / 64;
            if (BiomeDictionary.hasType((Biome)biomegenbase, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
                baseCount2 = 50 * baseScale / 64;
            }
            int count2 = (int)Math.round(random.nextGaussian() * Math.sqrt(baseCount2) + (double)baseCount2);
            for (int n2 = 0; n2 < count2; ++n2) {
                int x2 = chunkX * 16 + random.nextInt(16);
                int y2 = random.nextInt(baseScale);
                int z2 = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(Ic2States.uraniumOre, 3).func_180709_b(world, random, new BlockPos(x2, y2, z2));
            }
        }
        if (this.genSilver) {
            int baseCount3 = 10 * baseScale / 64;
            count = (int)Math.round(random.nextGaussian() * Math.sqrt(baseCount3) + (double)baseCount3);
            for (n = 0; n < count; ++n) {
                x = chunkX * 16 + random.nextInt(16);
                y = random.nextInt(baseScale);
                z = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(Ic2States.silverOre, 5).func_180709_b(world, random, new BlockPos(x, y, z));
            }
        }
    }
}

