/*
 * Decompiled with CFR 0.152.
 */
package ic2.jeiIntigration.core.crafting;

import ic2.api.classic.recipe.crafting.IRecipeObject;
import ic2.core.IC2;
import ic2.core.item.recipe.AdvShapelessRecipe;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class ShapelessAdvRecipeWrapper
extends ShapelessRecipeWrapper<AdvShapelessRecipe>
implements ICraftingRecipeWrapper {
    AdvShapelessRecipe recipe;

    public ShapelessAdvRecipeWrapper(IJeiHelpers helper, AdvShapelessRecipe adv) {
        super(helper, (IRecipe)adv);
        this.recipe = adv;
    }

    public void getIngredients(IIngredients ingridient) {
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        boolean hidden = this.recipe.isInvisible() && IC2.config.getFlag("SecretRecipeHiding");
        for (IRecipeObject obj : this.recipe.getRecipeInput()) {
            if (hidden) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(Ic2Items.displayIcons[8].func_77946_l());
                inputs.add(list);
                continue;
            }
            inputs.add(this.copyList(obj));
        }
        ingridient.setInputLists(ItemStack.class, inputs);
        ingridient.setOutput(ItemStack.class, (Object)(hidden ? Ic2Items.displayIcons[8].func_77946_l() : this.recipe.func_77571_b().func_77946_l()));
    }

    private List<ItemStack> copyList(IRecipeObject obj) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : obj.getItems()) {
            list.add(StackUtil.copyWithSize(stack, obj.getStackSize()));
        }
        return list;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        if (this.recipe.isInvisible() && IC2.config.getFlag("SecretRecipeHiding")) {
            String hiddenString = Ic2InfoLang.hiddenRecipe.getLocalized();
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(hiddenString);
            fontRendererObj.func_78276_b(hiddenString, recipeWidth - stringWidth + 20, 2, Color.gray.getRGB());
        }
    }
}

