/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.executable;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.parsing.ast.OperatorAssociativity;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.utils.Stack;

public abstract class BinaryOperator<E>
extends Operator<E> {
    public static final OperatorAssociativity DEFAULT_ASSOCIATIVITY = OperatorAssociativity.LEFT;
    public final OperatorAssociativity associativity;

    @Override
    public OperatorArity arity() {
        return OperatorArity.BINARY;
    }

    private BinaryOperator(String id, int precedence, OperatorAssociativity associativity) {
        super(id, precedence);
        this.associativity = associativity;
    }

    private BinaryOperator(String id, int precendence) {
        this(id, precendence, DEFAULT_ASSOCIATIVITY);
    }

    @Override
    public boolean isLowerPriority(Operator<E> other) {
        return this.associativity.isLessThan(this.precedence, other.precedence);
    }

    public String toString() {
        return "BinaryOperator [" + this.id + "]";
    }

    public static abstract class StackBased<E>
    extends BinaryOperator<E> {
        public StackBased(String id, int precedence, OperatorAssociativity associativity) {
            super(id, precedence, associativity);
        }

        public StackBased(String id, int precendence) {
            super(id, precendence);
        }

        public abstract void executeOnStack(Frame<E> var1);

        @Override
        public final void execute(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 2);
            this.executeOnStack(executionFrame);
            executionFrame.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Scoped<E>
    extends BinaryOperator<E> {
        public Scoped(String id, int precedence, OperatorAssociativity associativity) {
            super(id, precedence, associativity);
        }

        public Scoped(String id, int precendence) {
            super(id, precendence);
        }

        public abstract E execute(SymbolMap<E> var1, E var2, E var3);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.execute(frame.symbols(), left, right);
            stack.push(result);
        }
    }

    public static abstract class Direct<E>
    extends BinaryOperator<E> {
        public Direct(String id, int precedence, OperatorAssociativity associativity) {
            super(id, precedence, associativity);
        }

        public Direct(String id, int precendence) {
            super(id, precendence);
        }

        public abstract E execute(E var1, E var2);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E right = stack.pop();
            E left = stack.pop();
            E result = this.execute(left, right);
            stack.push(result);
        }
    }
}

