/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.bitmap;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

public class BitMapUtils {
    public static <T> Iterator<Map.Entry<T, Boolean>> createFlagIterator(IReadableBitMap<T> map, Iterable<T> values) {
        return BitMapUtils.createFlagIterator(map, values.iterator());
    }

    public static <T> Iterator<Map.Entry<T, Boolean>> createFlagIterator(final IReadableBitMap<T> map, final Iterator<T> values) {
        return new UnmodifiableIterator<Map.Entry<T, Boolean>>(){

            public boolean hasNext() {
                return values.hasNext();
            }

            public Map.Entry<T, Boolean> next() {
                Object key = values.next();
                boolean value = map.get(key);
                return Maps.immutableEntry(key, (Object)value);
            }
        };
    }

    public static <T> Iterator<T> createTrueValuesIterator(IReadableBitMap<T> map, Iterable<T> values) {
        return BitMapUtils.createTrueValuesIterator(map, values.iterator());
    }

    public static <T> Iterator<T> createTrueValuesIterator(final IReadableBitMap<T> map, final Iterator<T> values) {
        return new AbstractIterator<T>(){

            protected T computeNext() {
                while (values.hasNext()) {
                    Object key = values.next();
                    if (!map.get(key)) continue;
                    return key;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> IValueProvider<Boolean> singleBitProvider(IReadableBitMap<T> map, T key) {
        return () -> map.get(key);
    }

    public static <T> IValueReceiver<Boolean> singleBitReceiver(IWriteableBitMap<T> map, T key) {
        return value -> map.set(key, (boolean)value);
    }

    public static IValueReceiver<Boolean> singleBitReceiver(IRpcIntBitMap map, int key) {
        return value -> map.set(key, (boolean)value);
    }

    public static IWriteableBitMap<EnumFacing> createRpcAdapter(final IRpcDirectionBitMap map) {
        return new IWriteableBitMap<EnumFacing>(){

            @Override
            public void toggle(EnumFacing value) {
                map.toggle(value);
            }

            @Override
            public void set(EnumFacing key, boolean value) {
                map.set(key, value);
            }

            @Override
            public void mark(EnumFacing value) {
                map.mark(value);
            }

            @Override
            public void clearAll() {
                map.clearAll();
            }

            @Override
            public void clear(EnumFacing value) {
                map.clear(value);
            }
        };
    }

    public static IWriteableBitMap<Integer> createRpcAdapter(final IRpcIntBitMap map) {
        return new IWriteableBitMap<Integer>(){

            @Override
            public void toggle(Integer value) {
                map.toggle(value);
            }

            @Override
            public void set(Integer key, boolean value) {
                map.set(key, value);
            }

            @Override
            public void mark(Integer value) {
                map.mark(value);
            }

            @Override
            public void clearAll() {
                map.clearAll();
            }

            @Override
            public void clear(Integer value) {
                map.clear(value);
            }
        };
    }
}

