/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.client.lib.obj;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.lib.obj.IModelCustom;
import thaumcraft.client.lib.obj.IModelCustomLoader;
import thaumcraft.client.lib.obj.ObjModelLoader;
import thaumcraft.client.lib.obj.WavefrontObject;

@SideOnly(value=Side.CLIENT)
public class AdvancedModelLoader {
    private static Map<String, IModelCustomLoader> instances = Maps.newHashMap();

    public static void registerModelHandler(IModelCustomLoader modelHandler) {
        for (String suffix : modelHandler.getSuffixes()) {
            instances.put(suffix, modelHandler);
        }
    }

    public static IModelCustom loadModel(ResourceLocation resource) throws IllegalArgumentException, WavefrontObject.ModelFormatException {
        String name = resource.func_110623_a();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            FMLLog.severe((String)"The resource name %s is not valid", (Object[])new Object[]{resource});
            throw new IllegalArgumentException("The resource name is not valid");
        }
        String suffix = name.substring(i + 1);
        IModelCustomLoader loader = instances.get(suffix);
        if (loader == null) {
            FMLLog.severe((String)"The resource name %s is not supported", (Object[])new Object[]{resource});
            throw new IllegalArgumentException("The resource name is not supported");
        }
        return loader.loadInstance(resource);
    }

    public static Collection<String> getSupportedSuffixes() {
        return instances.keySet();
    }

    static {
        AdvancedModelLoader.registerModelHandler(new ObjModelLoader());
    }
}

