/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.network.MuseByteBufferUtils;
import net.machinemuse.powersuits.common.config.CosmeticPresetSaveLoad;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.config.MPSServerSettings;
import net.machinemuse.powersuits.common.config.MPSSettings;
import net.machinemuse.powersuits.network.MPSPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketCosmeticPresetUpdate
implements IMessage {
    ResourceLocation registryName;
    String name;
    NBTTagCompound cosmeticSettings;

    public MusePacketCosmeticPresetUpdate() {
    }

    public MusePacketCosmeticPresetUpdate(ResourceLocation registryNameIn, String nameIn, NBTTagCompound cosmeticSettingsIn) {
        this.registryName = registryNameIn;
        this.name = nameIn;
        this.cosmeticSettings = cosmeticSettingsIn;
    }

    public void fromBytes(ByteBuf buf) {
        this.registryName = new ResourceLocation(MuseByteBufferUtils.readUTF8String((ByteBuf)buf));
        this.name = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
        this.cosmeticSettings = MuseByteBufferUtils.readCompressedNBT((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.registryName.toString());
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        MuseByteBufferUtils.writeCompressedNBT((ByteBuf)buf, (NBTTagCompound)this.cosmeticSettings);
    }

    public static class Handler
    implements IMessageHandler<MusePacketCosmeticPresetUpdate, IMessage> {
        public IMessage onMessage(MusePacketCosmeticPresetUpdate message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                boolean allowCosmeticPresetCreation;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()) {
                    allowCosmeticPresetCreation = player.func_70005_c_().equals(FMLCommonHandler.instance().getMinecraftServerInstance().func_71214_G());
                } else {
                    UserListOpsEntry opEntry = (UserListOpsEntry)FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
                    int opLevel = opEntry != null ? opEntry.func_152644_a() : 0;
                    boolean bl = allowCosmeticPresetCreation = opLevel == 4;
                }
                if (allowCosmeticPresetCreation) {
                    player.func_71121_q().func_152344_a(() -> {
                        ResourceLocation registryName = message.registryName;
                        String name = message.name;
                        NBTTagCompound cosmeticSettings = message.cosmeticSettings;
                        MPSServerSettings settings = MPSConfig.INSTANCE.getServerSettings();
                        if (settings != null) {
                            settings.updateCosmeticInfo(registryName, name, cosmeticSettings);
                            MPSPackets.sendToAll((IMessage)new MusePacketCosmeticPresetUpdate(registryName, name, cosmeticSettings));
                        } else {
                            MPSSettings.cosmetics.updateCosmeticInfo(registryName, name, cosmeticSettings);
                        }
                        if (CosmeticPresetSaveLoad.savePreset(registryName, name, cosmeticSettings)) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.powersuits.savesuccessful", new Object[0]));
                        }
                    });
                }
            } else {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ResourceLocation registryName = message.registryName;
                    String name = message.name;
                    NBTTagCompound cosmeticSettings = message.cosmeticSettings;
                    MPSServerSettings settings = MPSConfig.INSTANCE.getServerSettings();
                    settings.updateCosmeticInfo(registryName, name, cosmeticSettings);
                });
            }
            return null;
        }
    }
}

