/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookCategory
extends AbstractReadStateHolder
implements Comparable<BookCategory> {
    String name;
    String description;
    String parent;
    String flag;
    @SerializedName(value="icon")
    String iconRaw;
    int sortnum;
    boolean secret = false;
    transient Book book;
    transient Book trueProvider;
    transient boolean checkedParent = false;
    transient BookCategory parentCategory;
    transient List<BookCategory> children = new ArrayList<BookCategory>();
    transient List<BookEntry> entries = new ArrayList<BookEntry>();
    transient boolean locked;
    transient BookIcon icon = null;
    transient ResourceLocation resource;
    transient boolean built;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BookIcon getIcon() {
        if (this.icon == null) {
            this.icon = new BookIcon(this.iconRaw);
        }
        return this.icon;
    }

    public void addEntry(BookEntry entry) {
        this.entries.add(entry);
    }

    public void addChildCategory(BookCategory category) {
        this.children.add(category);
    }

    public List<BookEntry> getEntries() {
        return this.entries;
    }

    public BookCategory getParentCategory() {
        if (!this.checkedParent && !this.isRootCategory()) {
            this.parentCategory = this.parent.contains(":") ? this.book.contents.categories.get(new ResourceLocation(this.parent)) : this.book.contents.categories.get(new ResourceLocation(this.book.getModNamespace(), this.parent));
            this.checkedParent = true;
        }
        return this.parentCategory;
    }

    public void updateLockStatus(boolean rootOnly) {
        boolean currLocked;
        block4: {
            if (rootOnly && !this.isRootCategory()) {
                return;
            }
            this.children.forEach(c -> c.updateLockStatus(false));
            currLocked = this.locked;
            this.locked = true;
            for (BookCategory c2 : this.children) {
                if (c2.isLocked()) continue;
                this.locked = false;
                break block4;
            }
            for (BookEntry e : this.entries) {
                if (e.isLocked()) continue;
                this.locked = false;
                break;
            }
        }
        if (!this.locked && currLocked != this.locked) {
            this.book.markUpdated();
        }
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public boolean isLocked() {
        return !PatchouliConfig.disableAdvancementLocking && this.locked;
    }

    public boolean isRootCategory() {
        return this.parent == null || this.parent.isEmpty();
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    public boolean canAdd() {
        return this.flag == null || this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    @Override
    public int compareTo(BookCategory o) {
        if (o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        return this.sortnum - o.sortnum;
    }

    public void setBook(Book book) {
        if (book.isExtension) {
            this.book = book.extensionTarget;
            this.trueProvider = book;
        } else {
            this.book = book;
        }
    }

    public void build(ResourceLocation resource) {
        if (this.built) {
            return;
        }
        this.resource = resource;
        BookCategory parent = this.getParentCategory();
        if (parent != null) {
            parent.addChildCategory(this);
        }
        this.built = true;
    }

    public Book getBook() {
        return this.book;
    }

    public Book getTrueProvider() {
        return this.trueProvider;
    }

    public boolean isExtension() {
        return this.getTrueProvider() != this.getBook();
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> entryStream = this.entries.stream().filter(e -> !e.isLocked()).map(AbstractReadStateHolder::getReadState);
        Stream<EntryDisplayState> childrenStream = this.children.stream().map(AbstractReadStateHolder::getReadState);
        return BookCategory.mostImportantState(entryStream, childrenStream);
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        if (this.parentCategory != null) {
            this.parentCategory.markReadStateDirty();
        } else {
            this.book.contents.markReadStateDirty();
        }
    }
}

