/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.blocks.shulker;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.common.blocks.shulker.IronShulkerBoxType;
import cpw.mods.ironchest.common.core.IronChestBlocks;
import cpw.mods.ironchest.common.core.IronChestCreativeTabs;
import cpw.mods.ironchest.common.tileentity.shulker.TileEntityIronShulkerBox;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIronShulkerBox
extends Block {
    public static final PropertyEnum<IronShulkerBoxType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", IronShulkerBoxType.class);
    private final EnumDyeColor color;
    private EnumFacing facingDirection;

    public BlockIronShulkerBox(EnumDyeColor colorIn, String nameIn) {
        super(Material.field_151573_f);
        this.color = colorIn;
        this.setRegistryName(nameIn);
        this.func_149663_c("IronShulkerBox" + colorIn.func_176610_l());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronShulkerBoxType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149647_a(IronChestCreativeTabs.tabIronChests);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_175149_v()) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityIronShulkerBox) {
            AxisAlignedBB axisalignedbb;
            EnumFacing enumfacing = ((TileEntityIronShulkerBox)tileentity).getFacing();
            boolean flag = ((TileEntityIronShulkerBox)tileentity).getAnimationStatus() == TileEntityIronShulkerBox.AnimationStatus.CLOSED ? !worldIn.func_184143_b((axisalignedbb = field_185505_j.func_72321_a((double)(0.5f * (float)enumfacing.func_82601_c()), (double)(0.5f * (float)enumfacing.func_96559_d()), (double)(0.5f * (float)enumfacing.func_82599_e())).func_191195_a((double)enumfacing.func_82601_c(), (double)enumfacing.func_96559_d(), (double)enumfacing.func_82599_e())).func_186670_a(pos.func_177972_a(enumfacing))) : true;
            if (flag) {
                playerIn.openGui((Object)IronChest.instance, ((TileEntityIronShulkerBox)tileentity).getType().ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IronShulkerBoxType)((Object)state.func_177229_b(VARIANT_PROP))).makeEntity(this.color);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (IronShulkerBoxType type : IronShulkerBoxType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronShulkerBoxType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((IronShulkerBoxType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROP});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        this.facingDirection = facing;
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (stack.func_82837_s()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityIronShulkerBox) {
                ((TileEntityIronShulkerBox)tileentity).func_190575_a(stack.func_82833_r());
                ((TileEntityIronShulkerBox)tileentity).setFacing(this.facingDirection);
                worldIn.func_184138_a(pos, state, state, 3);
            }
        } else {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityIronShulkerBox) {
                TileEntityIronShulkerBox teic = (TileEntityIronShulkerBox)tileentity;
                teic.setFacing(this.facingDirection);
                worldIn.func_184138_a(pos, state, state, 3);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((IronShulkerBoxType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityIronShulkerBox tileentityironshulkerbox = (TileEntityIronShulkerBox)worldIn.func_175625_s(pos);
        tileentityironshulkerbox.setDestroyedByCreativePlayer(player.field_71075_bZ.field_75098_d);
        tileentityironshulkerbox.func_184281_d(player);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack itemstack;
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityIronShulkerBox && !(itemstack = ((TileEntityIronShulkerBox)tileentity).getDrop(state, false)).func_190926_b()) {
            drops.add((Object)itemstack);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityIronShulkerBox) {
            ItemStack itemstack = ((TileEntityIronShulkerBox)tileentity).getDrop(state, true);
            if (!itemstack.func_190926_b()) {
                BlockIronShulkerBox.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
            }
            worldIn.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityIronShulkerBox teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityIronShulkerBox && (teic = (TileEntityIronShulkerBox)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, worldIn, tooltip, advanced);
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("BlockEntityTag", 10)) {
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("BlockEntityTag");
            if (nbttagcompound1.func_150297_b("LootTable", 8)) {
                tooltip.add("???????");
            }
            if (nbttagcompound1.func_150297_b("Items", 9)) {
                if (nbttagcompound1.func_150297_b("ShulkerBoxSize", 3)) {
                    NonNullList nonnulllist = NonNullList.func_191197_a((int)nbttagcompound1.func_74762_e("ShulkerBoxSize"), (Object)ItemStack.field_190927_a);
                    ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
                    int i = 0;
                    int j = 0;
                    for (ItemStack itemstack : nonnulllist) {
                        if (itemstack.func_190926_b()) continue;
                        ++j;
                        if (i > 4) continue;
                        ++i;
                        tooltip.add(String.format("%s x%d", itemstack.func_82833_r(), itemstack.func_190916_E()));
                    }
                    if (j - i > 0) {
                        tooltip.add(String.format(TextFormatting.ITALIC + I18n.func_74838_a((String)"container.shulkerBox.more"), j - i));
                    }
                } else {
                    NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                    ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
                    int i = 0;
                    int j = 0;
                    for (ItemStack itemstack : nonnulllist) {
                        if (itemstack.func_190926_b()) continue;
                        ++j;
                        if (i > 4) continue;
                        ++i;
                        tooltip.add(String.format("%s x%d", itemstack.func_82833_r(), itemstack.func_190916_E()));
                    }
                    if (j - i > 0) {
                        tooltip.add(String.format(TextFormatting.ITALIC + I18n.func_74838_a((String)"container.shulkerBox.more"), j - i));
                    }
                }
            }
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileentity = source.func_175625_s(pos);
        return tileentity instanceof TileEntityIronShulkerBox ? ((TileEntityIronShulkerBox)tileentity).getBoundingBox() : field_185505_j;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        TileEntityIronShulkerBox tileentityironshulkerbox = (TileEntityIronShulkerBox)worldIn.func_175625_s(pos);
        NBTTagCompound nbttagcompound = tileentityironshulkerbox.saveToNbt(new NBTTagCompound());
        if (!nbttagcompound.func_82582_d()) {
            itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return itemstack;
    }

    public static Block getBlockByColor(EnumDyeColor colorIn) {
        switch (colorIn) {
            case WHITE: {
                return IronChestBlocks.ironShulkerBoxWhiteBlock;
            }
            case ORANGE: {
                return IronChestBlocks.ironShulkerBoxOrangeBlock;
            }
            case MAGENTA: {
                return IronChestBlocks.ironShulkerBoxMagentaBlock;
            }
            case LIGHT_BLUE: {
                return IronChestBlocks.ironShulkerBoxLightBlueBlock;
            }
            case YELLOW: {
                return IronChestBlocks.ironShulkerBoxYellowBlock;
            }
            case LIME: {
                return IronChestBlocks.ironShulkerBoxLimeBlock;
            }
            case PINK: {
                return IronChestBlocks.ironShulkerBoxPinkBlock;
            }
            case GRAY: {
                return IronChestBlocks.ironShulkerBoxGrayBlock;
            }
            case SILVER: {
                return IronChestBlocks.ironShulkerBoxSilverBlock;
            }
            case CYAN: {
                return IronChestBlocks.ironShulkerBoxCyanBlock;
            }
            default: {
                return IronChestBlocks.ironShulkerBoxPurpleBlock;
            }
            case BLUE: {
                return IronChestBlocks.ironShulkerBoxBlueBlock;
            }
            case BROWN: {
                return IronChestBlocks.ironShulkerBoxBrownBlock;
            }
            case GREEN: {
                return IronChestBlocks.ironShulkerBoxGreenBlock;
            }
            case RED: {
                return IronChestBlocks.ironShulkerBoxRedBlock;
            }
            case BLACK: 
        }
        return IronChestBlocks.ironShulkerBoxBlackBlock;
    }

    public static ItemStack getColoredItemStack(EnumDyeColor colorIn, int damageIn) {
        return new ItemStack(BlockIronShulkerBox.getBlockByColor(colorIn), 1, damageIn);
    }

    @SideOnly(value=Side.CLIENT)
    public static EnumDyeColor getColorFromBlock(Block blockIn) {
        return blockIn instanceof BlockIronShulkerBox ? ((BlockIronShulkerBox)blockIn).getColor() : EnumDyeColor.PURPLE;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return this.color;
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }
}

