/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_Biome;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProvider;
import galaxyspace.systems.BarnardsSystem.core.configs.BRConfigCore;
import galaxyspace.systems.BarnardsSystem.core.registers.BRBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ColorBlockHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WorldClient world = FMLClientHandler.instance().getWorldClient();
                if (world != null && world.field_73011_w instanceof WE_WorldProvider) {
                    WE_Biome biome = WE_Biome.getBiomeAt((long)pos.func_177958_n(), (long)pos.func_177952_p());
                    return biome.biomeBlockGrassColor;
                }
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        IBlockColor water_grassColourHandler = (state, blockAccess, pos, tintIndex) -> 0x88CC44;
        if (BRConfigCore.enableBarnardsSystems) {
            blockColors.func_186722_a(grassColourHandler, new Block[]{Blocks.field_150349_c, BRBlocks.BARNARDA_C_GRASS, BRBlocks.BARNARDA_C_WATER_GRASS});
            blockColors.func_186722_a(water_grassColourHandler, new Block[]{BRBlocks.BARNARDA_C_WATER_GRASS});
        }
        IBlockColor waterColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                WorldClient world = FMLClientHandler.instance().getWorldClient();
                if (world != null && world.field_73011_w instanceof WE_WorldProvider) {
                    return WE_Biome.getBiomeAt((long)((long)pos.func_177958_n()), (long)((long)pos.func_177952_p())).biomeBlockWaterColor;
                }
                return BiomeColorHelper.func_180288_c((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        blockColors.func_186722_a(waterColourHandler, new Block[]{Blocks.field_150355_j, Blocks.field_150358_i});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        };
        if (BRConfigCore.enableBarnardsSystems) {
            itemColors.func_186731_a(itemBlockColourHandler, new Block[]{BRBlocks.BARNARDA_C_GRASS});
        }
    }
}

