/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.xnet;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftools.blocks.storagemonitor.InventoryAccessSettings;
import mcjty.rftools.xnet.StorageChannelSettings;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.AbstractConnectorSettings;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class StorageConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_MODE = "mode";
    public static final String TAG_BIGUI = "bigui";
    public static final String TAG_BIAUTO = "biauto";
    public static final String TAG_BISCREEN = "biscreen";
    public static final String TAG_BOGUI = "bogui";
    public static final String TAG_BOAUTO = "boauto";
    public static final String TAG_BOSCREEN = "boscreen";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final String TAG_OREDICT = "od";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    private Mode mode = Mode.INVENTORY;
    private InventoryAccessSettings accessSettings = new InventoryAccessSettings();

    public StorageConnectorSettings(@Nonnull EnumFacing side) {
        super(side);
    }

    public Mode getMode() {
        return this.mode;
    }

    public InventoryAccessSettings getAccessSettings() {
        return this.accessSettings;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.mode = Mode.values()[tag.func_74771_c(TAG_MODE)];
        this.accessSettings.setBlockInputGui(tag.func_74767_n(TAG_BIGUI));
        this.accessSettings.setBlockInputAuto(tag.func_74767_n(TAG_BIAUTO));
        this.accessSettings.setBlockInputScreen(tag.func_74767_n(TAG_BISCREEN));
        this.accessSettings.setBlockOutputGui(tag.func_74767_n(TAG_BOGUI));
        this.accessSettings.setBlockOutputAuto(tag.func_74767_n(TAG_BOAUTO));
        this.accessSettings.setBlockOutputScreen(tag.func_74767_n(TAG_BOSCREEN));
        for (int i = 0; i < 18; ++i) {
            if (tag.func_74764_b("filter" + i)) {
                NBTTagCompound itemTag = tag.func_74775_l("filter" + i);
                this.accessSettings.getFilters().set(i, (Object)new ItemStack(itemTag));
                continue;
            }
            this.accessSettings.getFilters().set(i, (Object)ItemStack.field_190927_a);
        }
        this.accessSettings.setOredictMode(tag.func_74767_n("oredictMode"));
        this.accessSettings.setMetaMode(tag.func_74767_n("metaMode"));
        this.accessSettings.setNbtMode(tag.func_74767_n("nbtMode"));
        this.accessSettings.setBlacklist(tag.func_74767_n(TAG_BLACKLIST));
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a(TAG_MODE, (byte)this.mode.ordinal());
        tag.func_74757_a(TAG_BIGUI, this.accessSettings.isBlockInputGui());
        tag.func_74757_a(TAG_BIAUTO, this.accessSettings.isBlockInputAuto());
        tag.func_74757_a(TAG_BISCREEN, this.accessSettings.isBlockInputScreen());
        tag.func_74757_a(TAG_BOGUI, this.accessSettings.isBlockOutputGui());
        tag.func_74757_a(TAG_BOAUTO, this.accessSettings.isBlockOutputAuto());
        tag.func_74757_a(TAG_BOSCREEN, this.accessSettings.isBlockOutputScreen());
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.accessSettings.getFilters().get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            ((ItemStack)this.accessSettings.getFilters().get(i)).func_77955_b(itemTag);
            tag.func_74782_a("filter" + i, (NBTBase)itemTag);
        }
        tag.func_74757_a("oredictMode", this.accessSettings.isOredictMode());
        tag.func_74757_a("metaMode", this.accessSettings.isMetaMode());
        tag.func_74757_a("nbtMode", this.accessSettings.isNbtMode());
        tag.func_74757_a(TAG_BLACKLIST, this.accessSettings.isBlacklist());
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.mode) {
            case INVENTORY: {
                boolean inputBlocked = this.accessSettings.inputBlocked();
                boolean outputBlocked = this.accessSettings.outputBlocked();
                if (inputBlocked && outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 75, 13, 10);
                }
                if (inputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 48, 13, 10);
                }
                if (outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 0, 48, 13, 10);
                }
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 57, 13, 10);
            }
            case STORAGE: {
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 66, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return true;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        gui.shift(30).choices(TAG_MODE, "Set to 'inventory' or 'storage'", (Enum)this.mode, (Enum[])Mode.values());
        if (this.mode == Mode.INVENTORY) {
            gui.nl().label("Input ").shift(12).label("UI").toggle(TAG_BIGUI, "Block input from scanner UI", this.accessSettings.isBlockInputGui()).label("Auto").toggle(TAG_BIAUTO, "Block input from automation", this.accessSettings.isBlockInputAuto()).label("Scr").toggle(TAG_BISCREEN, "Block input from screens", this.accessSettings.isBlockInputScreen());
            gui.nl().label("Output").shift(10).label("UI").toggle(TAG_BOGUI, "Block extraction from scanner UI", this.accessSettings.isBlockOutputGui()).label("Auto").toggle(TAG_BOAUTO, "Block extraction from automation", this.accessSettings.isBlockOutputAuto()).label("Scr").toggle(TAG_BOSCREEN, "Block extraction from screens", this.accessSettings.isBlockOutputScreen());
            gui.nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.accessSettings.isBlacklist()).shift(2).toggleText(TAG_OREDICT, "Ore dictionary matching", "Ore", this.accessSettings.isOredictMode()).shift(2).toggleText(TAG_META, "Metadata matching", "Meta", this.accessSettings.isMetaMode()).shift(2).toggleText(TAG_NBT, "NBT matching", "NBT", this.accessSettings.isNbtMode()).nl();
            for (int i = 0; i < 18; ++i) {
                gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.accessSettings.getFilters().get(i));
            }
        }
    }

    private static boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.mode = Mode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.accessSettings.setBlockInputGui(StorageConnectorSettings.toBool(data.get(TAG_BIGUI)));
        this.accessSettings.setBlockInputAuto(StorageConnectorSettings.toBool(data.get(TAG_BIAUTO)));
        this.accessSettings.setBlockInputScreen(StorageConnectorSettings.toBool(data.get(TAG_BISCREEN)));
        this.accessSettings.setBlockOutputGui(StorageConnectorSettings.toBool(data.get(TAG_BOGUI)));
        this.accessSettings.setBlockOutputAuto(StorageConnectorSettings.toBool(data.get(TAG_BOAUTO)));
        this.accessSettings.setBlockOutputScreen(StorageConnectorSettings.toBool(data.get(TAG_BOSCREEN)));
        for (int i = 0; i < 18; ++i) {
            this.accessSettings.getFilters().set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.accessSettings.setOredictMode(StorageConnectorSettings.toBool(data.get(TAG_OREDICT)));
        this.accessSettings.setMetaMode(StorageConnectorSettings.toBool(data.get(TAG_META)));
        this.accessSettings.setNbtMode(StorageConnectorSettings.toBool(data.get(TAG_NBT)));
        this.accessSettings.setBlacklist(StorageConnectorSettings.toBool(data.get(TAG_BLACKLIST)));
    }

    public static enum Mode {
        INVENTORY,
        STORAGE;

    }
}

