/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energy;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.tile.NCTile;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public abstract class TileEnergy
extends NCTile
implements ITileEnergy,
IEnergyTile,
IEnergySink,
IEnergySource {
    @Nonnull
    private final EnergyStorage storage;
    @Nonnull
    private EnergyConnection[] energyConnections;
    @Nonnull
    private EnergyTileWrapper[] energySides;
    @Nonnull
    private EnergyTileWrapperGT[] energySidesGT;
    private boolean ic2reg = false;

    public TileEnergy(int capacity, @Nonnull EnergyConnection[] energyConnections) {
        this(capacity, capacity, energyConnections);
    }

    public TileEnergy(int capacity, int maxTransfer, @Nonnull EnergyConnection[] energyConnections) {
        this.storage = new EnergyStorage(capacity, maxTransfer);
        this.energyConnections = energyConnections;
        this.energySides = ITileEnergy.getDefaultEnergySides(this);
        this.energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getEnergyConnection(side).canReceive();
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getEnergyConnection(side).canExtract();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSourceTier() + 3), (double)this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)NCConfig.rf_per_eu);
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return Math.min(Math.pow(2.0, 2 * this.getSinkTier() + 3), (double)this.getEnergyStorage().receiveEnergy(this.getEnergyStorage().getMaxTransfer(), true) / (double)NCConfig.rf_per_eu);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.getEnergyStorage().extractEnergy((int)((double)NCConfig.rf_per_eu * amount), false);
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int energyReceived = this.getEnergyStorage().receiveEnergy((int)((double)NCConfig.rf_per_eu * amount), true);
        this.getEnergyStorage().receiveEnergy(energyReceived, false);
        return amount - (double)energyReceived / (double)NCConfig.rf_per_eu;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.getEUSourceTier();
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.getEUSinkTier();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void addTileToENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && !this.ic2reg) {
            EnergyNet.instance.addTile((TileEntity)this);
            this.ic2reg = true;
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void removeTileFromENet() {
        if (!this.field_145850_b.field_72995_K && ModCheck.ic2Loaded() && this.ic2reg) {
            EnergyNet.instance.removeTile((IEnergyTile)this);
            this.ic2reg = false;
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergy(nbt);
        this.writeEnergyConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergy(nbt);
        this.readEnergyConnections(nbt);
    }

    public void setEnergyConnectionAll(EnergyConnection energyConnection) {
        this.energyConnections = ITileEnergy.energyConnectionAll(energyConnection);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (this.hasEnergySideCapability(side)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return true;
            }
            if (ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return true;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (this.hasEnergySideCapability(side)) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            if (ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                return (T)this.getEnergySideGT(this.nonNullSide(side));
            }
        }
        return super.getCapability(capability, side);
    }
}

