/*
 * Decompiled with CFR 0.152.
 */
package al132.alchemistry.blocks;

import al132.alchemistry.blocks.BaseBlock;
import al132.alchemistry.items.TooltipItemBlock;
import al132.alib.utils.extensions.StringKt;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J0\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0004J(\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0017J\u0016\u0010&\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010+\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016\u00a8\u0006,"}, d2={"Lal132/alchemistry/blocks/WetSandBlock;", "Lal132/alchemistry/blocks/BaseBlock;", "()V", "canFallThrough", "", "state", "Lnet/minecraft/block/state/IBlockState;", "canSustainPlant", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "direction", "Lnet/minecraft/util/EnumFacing;", "plantable", "Lnet/minecraftforge/common/IPlantable;", "checkFallable", "", "worldIn", "Lnet/minecraft/world/World;", "getDustColor", "", "neighborChanged", "blockIn", "Lnet/minecraft/block/Block;", "fromPos", "onBlockAdded", "onBroken", "onEndFalling", "p_176502_3_", "p_176502_4_", "onStartFalling", "fallingEntity", "Lnet/minecraft/entity/item/EntityFallingBlock;", "randomDisplayTick", "stateIn", "rand", "Ljava/util/Random;", "registerItemBlock", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/item/Item;", "tickRate", "updateTick", "alchemistry"})
public final class WetSandBlock
extends BaseBlock {
    public void registerItemBlock(@NotNull RegistryEvent.Register<Item> event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        event.getRegistry().register(new TooltipItemBlock((Block)this, StringKt.translate((String)"tile.wet_sand.tooltip")).setRegistryName(this.getRegistryName()));
    }

    public boolean canSustainPlant(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing direction, @NotNull IPlantable plantable) {
        IBlockState plant;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        Intrinsics.checkParameterIsNotNull((Object)plantable, (String)"plantable");
        IBlockState iBlockState = plant = plantable.getPlant(world, pos.func_177972_a(direction));
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"plant");
        return iBlockState.func_177230_c() instanceof BlockCactus || plant.func_177230_c() instanceof BlockReed;
    }

    public void func_176213_c(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)blockIn, (String)"blockIn");
        Intrinsics.checkParameterIsNotNull((Object)fromPos, (String)"fromPos");
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private final void checkFallable(World worldIn, BlockPos pos) {
        block11: {
            block10: {
                if (worldIn.func_175623_d(pos.func_177977_b())) break block10;
                IBlockState iBlockState = worldIn.func_180495_p(pos.func_177977_b());
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(pos.down())");
                if (!this.canFallThrough(iBlockState)) break block11;
            }
            if (pos.func_177956_o() >= 0) {
                int i = 32;
                if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                    if (!worldIn.field_72995_K) {
                        EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                        this.onStartFalling(entityfallingblock);
                        worldIn.func_72838_d((Entity)entityfallingblock);
                    }
                } else {
                    IBlockState state = worldIn.func_180495_p(pos);
                    worldIn.func_175698_g(pos);
                    BlockPos blockPos = pos.func_177977_b();
                    Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.down()");
                    BlockPos blockpos = blockPos;
                    while (true) {
                        if (!worldIn.func_175623_d(blockpos)) {
                            IBlockState iBlockState = worldIn.func_180495_p(blockpos);
                            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(blockpos)");
                            if (!this.canFallThrough(iBlockState)) break;
                        }
                        if (blockpos.func_177956_o() <= 0) break;
                        Intrinsics.checkExpressionValueIsNotNull((Object)blockpos.func_177977_b(), (String)"blockpos.down()");
                    }
                    if (blockpos.func_177956_o() > 0) {
                        worldIn.func_175656_a(blockpos.func_177984_a(), state);
                    }
                }
            }
        }
    }

    protected final void onStartFalling(@NotNull EntityFallingBlock fallingEntity) {
        Intrinsics.checkParameterIsNotNull((Object)fallingEntity, (String)"fallingEntity");
    }

    public int func_149738_a(@NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        return 2;
    }

    public final boolean canFallThrough(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public final void onEndFalling(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState p_176502_3_, @NotNull IBlockState p_176502_4_) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)p_176502_3_, (String)"p_176502_3_");
        Intrinsics.checkParameterIsNotNull((Object)p_176502_4_, (String)"p_176502_4_");
    }

    public final void onBroken(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@NotNull IBlockState stateIn, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)stateIn, (String)"stateIn");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        if (rand.nextInt(16) == 0) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iBlockState = worldIn.func_180495_p(blockpos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(blockpos)");
            if (this.canFallThrough(iBlockState)) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (double)pos.func_177956_o() - 0.05;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final int getDustColor(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return -16777216;
    }

    public WetSandBlock() {
        Material material = Material.field_151595_p;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.SAND");
        super("wet_sand", material);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
    }
}

