/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;
import reborncore.common.RebornCoreConfig;

public class PowerSystem {
    public static File selectedFile;
    private static EnergySystem selectedSystem;
    private static final char[] magnitude;

    public static String getLocaliszedPower(double eu) {
        return PowerSystem.getLocaliszedPower((int)eu);
    }

    public static String getLocaliszedPowerNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerNoSuffix((int)eu);
    }

    public static String getLocaliszedPowerFormatted(double eu) {
        return PowerSystem.getLocaliszedPowerFormatted((int)eu);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(double eu) {
        return PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)eu);
    }

    public static String getLocaliszedPower(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, PowerSystem.getDisplayPower().abbreviation);
    }

    public static String getLocaliszedPowerNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, "");
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, "");
    }

    public static String getLocaliszedPowerFormatted(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, EnergySystem.EU.abbreviation);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, PowerSystem.getDisplayPower().abbreviation, true);
    }

    public static String getLocaliszedPowerFormattedNoSuffix(int eu) {
        if (PowerSystem.getDisplayPower() == EnergySystem.EU) {
            return PowerSystem.getRoundedString(eu, "", true);
        }
        return PowerSystem.getRoundedString(eu * RebornCoreConfig.euPerFU, "", true);
    }

    private static String getRoundedString(int value, String units) {
        return PowerSystem.getRoundedString(value, units, false);
    }

    private static String getRoundedString(int euValue, String units, boolean doFormat) {
        String ret = "";
        float value = 0.0f;
        int i = 0;
        boolean showMagnitude = true;
        if (euValue < 0) {
            ret = "-";
            euValue = -euValue;
        }
        if (euValue < 1000) {
            doFormat = false;
            showMagnitude = false;
            value = euValue;
        } else if (euValue >= 1000) {
            i = 0;
            while (true) {
                if (euValue < 10000 && euValue % 1000 >= 100) {
                    value = euValue / 1000;
                    value += (float)euValue % 1000.0f / 1000.0f;
                    break;
                }
                if ((euValue /= 1000) < 1000) {
                    value = euValue;
                    break;
                }
                ++i;
            }
        }
        ret = FMLCommonHandler.instance().getEffectiveSide().isClient() && doFormat ? ret + NumberFormat.getNumberInstance(Locale.forLanguageTag(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())).format(value) : ret + value;
        if (showMagnitude) {
            ret = ret + magnitude[i];
        }
        if (units != "") {
            ret = ret + " " + units;
        }
        return ret;
    }

    public static EnergySystem getDisplayPower() {
        return selectedSystem;
    }

    public static void bumpPowerConfig() {
        int value = selectedSystem.ordinal() + 1;
        if (value == EnergySystem.values().length) {
            value = 0;
        }
        selectedSystem = EnergySystem.values()[value];
        PowerSystem.writeFile();
    }

    public static void readFile() {
        if (!selectedFile.exists()) {
            PowerSystem.writeFile();
        }
        if (selectedFile.exists()) {
            try {
                String value = FileUtils.readFileToString((File)selectedFile, (Charset)StandardCharsets.UTF_8);
                selectedSystem = Arrays.stream(EnergySystem.values()).filter(energySystem -> energySystem.abbreviation.equalsIgnoreCase(value)).findFirst().orElse(EnergySystem.values()[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeFile() {
        try {
            FileUtils.write((File)selectedFile, (CharSequence)PowerSystem.selectedSystem.abbreviation, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PowerSystem.readFile();
    }

    static {
        selectedSystem = EnergySystem.values()[0];
        magnitude = new char[]{'k', 'M', 'G', 'T'};
    }

    public static enum EnergySystem {
        FE(-4315110, "FE", 113, 151, -6943475),
        EU(-8387072, "EU", 141, 151, -10027008);

        public int colour;
        public int altColour;
        public String abbreviation;
        public int xBar;
        public int yBar;

        private EnergySystem(int colour, String abbreviation, int xBar, int yBar, int altColour) {
            this.colour = colour;
            this.abbreviation = abbreviation;
            this.xBar = xBar;
            this.yBar = yBar;
            this.altColour = altColour;
        }
    }
}

