/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import openmods.gui.IComponentParent;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;

public class GuiComponentVCenter
extends BaseComposite {
    private int width;
    private int height;

    public GuiComponentVCenter(int x, int y, int height) {
        super(x, y);
        this.height = height;
    }

    @Override
    public void init(IComponentParent parent) {
        super.init(parent);
        for (BaseComponent c : this.components) {
            if (this.height >= 0) {
                int y = (this.height - c.getHeight()) / 2;
                c.setY(y);
            }
            this.width = Math.max(this.width, c.getX() + c.getWidth());
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static BaseComposite wrap(int x, int y, int width, BaseComponent component) {
        return new GuiComponentVCenter(x, y, width).addComponent(component);
    }
}

