/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.util;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class TradeCache
implements INetworkFieldData {
    Map<Integer, Map<Integer, Integer>> trades = new LinkedHashMap<Integer, Map<Integer, Integer>>();

    @Override
    public void read(IInputBuffer buffer) {
        this.trades.clear();
        int tradesExpected = buffer.readByte();
        for (int i = 0; i < tradesExpected; ++i) {
            byte id = buffer.readByte();
            LinkedHashMap<Integer, Integer> key = new LinkedHashMap<Integer, Integer>();
            int subTradesExpected = buffer.readByte();
            for (int x = 0; x < subTradesExpected; ++x) {
                byte subID = buffer.readByte();
                short count = buffer.readShort();
                key.put(Integer.valueOf(subID), Integer.valueOf(count));
            }
            this.trades.put(Integer.valueOf(id), key);
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeByte((byte)this.trades.size());
        for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.trades.entrySet()) {
            buffer.writeByte(entry.getKey().byteValue());
            Map<Integer, Integer> subMap = entry.getValue();
            buffer.writeByte((byte)subMap.size());
            for (Map.Entry<Integer, Integer> subEntry : subMap.entrySet()) {
                buffer.writeByte(subEntry.getKey().byteValue());
                buffer.writeShort(subEntry.getValue().shortValue());
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, Map<Integer, Integer>> entry : this.trades.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("Key", entry.getKey().intValue());
            NBTTagList dataList = new NBTTagList();
            for (Map.Entry<Integer, Integer> valueEntry : entry.getValue().entrySet()) {
                dataList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{valueEntry.getKey(), valueEntry.getValue()}));
            }
            data.func_74782_a("Value", (NBTBase)dataList);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.trades.clear();
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            this.trades.put(data.func_74762_e("Key"), map);
            NBTTagList dataList = data.func_150295_c("Value", 11);
            for (int x = 0; x < dataList.func_74745_c(); ++x) {
                int[] array = dataList.func_150306_c(x);
                map.put(array[0], array[1]);
            }
        }
    }

    public Map<Integer, Map<Integer, Integer>> getTrades() {
        return this.trades;
    }

    public boolean hasStuff() {
        return this.trades.size() > 0;
    }

    public void clear() {
        this.trades.clear();
    }

    public boolean hasTradeAdded(int id, int subID) {
        Map<Integer, Integer> subMap = this.trades.get(id);
        if (subMap == null) {
            return false;
        }
        return subMap.containsKey(subID);
    }

    public void addTrade(int tradeID, int subID, int amount) {
        Map<Integer, Integer> subMap = this.trades.get(tradeID);
        if (subMap == null) {
            subMap = new LinkedHashMap<Integer, Integer>();
            this.trades.put(tradeID, subMap);
        }
        subMap.put(subID, amount);
    }

    public int getTradeCount(int tradeID, int subID) {
        Map<Integer, Integer> subMap = this.trades.get(tradeID);
        if (subMap != null && subMap.containsKey(subID)) {
            return subMap.get(subID);
        }
        return -1;
    }

    public void removeTrade(int tradeID, int subID) {
        Map<Integer, Integer> subMap = this.trades.get(tradeID);
        if (subMap != null) {
            subMap.remove(subID);
            if (subMap.isEmpty()) {
                this.trades.remove(tradeID);
            }
        }
    }
}

