/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.core.IC2;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class AdjustableValueDensityScanner
implements IScanner {
    @Override
    public boolean isAdv(ItemStack stack) {
        return false;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        int value = ClassicRecipes.oreRegistry.getOreValue(state);
        if (value == 0) {
            return 0;
        }
        return this.getScanninglevel(stack) == value ? 1 : 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        return this.getOreValue(stack, state);
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return new LinkedHashSet<IBlockState>(ClassicRecipes.oreRegistry.getValueToOresMap().getOrDefault(this.getScanninglevel(stack), new ArrayList()));
    }

    @Override
    public int getRadius(ItemStack stack) {
        return 6;
    }

    @Override
    public int getCost(ItemStack stack) {
        return 1250;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return false;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return Ic2ItemLang.scannerAdjusted;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return true;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTooltip) {
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.ScannerLVLChange));
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return true;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        if (player.func_70093_af()) {
            int max = ClassicRecipes.oreRegistry.getHighestOreValue();
            int scan = this.getScanninglevel(stack) + 1;
            if (scan > max) {
                scan = 1;
            }
            this.setScanninglevel(stack, scan);
            IC2.platform.messagePlayer(player, Ic2InfoLang.scannerNextScanLevel, scan);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return true;
    }

    public int getScanninglevel(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Scan");
    }

    public void setScanninglevel(ItemStack stack, int level) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("Scan", level);
    }
}

