/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.utils.PositionPool;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemFireExtinguisher
extends XUItemFlat {
    @Override
    public void registerTextures() {
        Textures.register("fire_extinguisher");
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    @Override
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        return "fire_extinguisher";
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityIn, int count) {
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer playerIn = (EntityPlayer)entityIn;
        World worldIn = playerIn.field_70170_p;
        if ((count & 3) != 0 && !worldIn.field_72995_K) {
            return;
        }
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        double x0 = playerIn.field_70165_t;
        double y0 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double z0 = playerIn.field_70161_v;
        Vec3d startPos = new Vec3d(x0, y0, z0);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float dy = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float dx = f3 * f4;
        float dz = f2 * f4;
        if (worldIn.field_72995_K) {
            Random r = worldIn.field_73012_v;
            for (int i = 0; i < 10; ++i) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0, (playerIn.field_70163_u + 2.0 * y0) / 3.0, z0, (double)dx + r.nextGaussian() * 0.2, (double)dy + r.nextGaussian() * 0.2, (double)dz + r.nextGaussian() * 0.2, new int[0]);
            }
            return;
        }
        double reach = 8.0;
        Vec3d finalPos = startPos.func_72441_c((double)dx * reach, (double)dy * reach, (double)dz * reach);
        RayTraceResult rayTraceResult = worldIn.func_147447_a(startPos, finalPos, false, true, true);
        if (rayTraceResult != null) {
            finalPos = rayTraceResult.field_72307_f;
            reach = finalPos.func_72438_d(startPos);
        }
        PositionPool pool = new PositionPool();
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        BlockPos prevPos = null;
        for (double t = 0.0; t <= reach; t += 0.5) {
            BlockPos p = pool.getPos((int)Math.round(startPos.field_72450_a + t * (double)dx), (int)Math.round(startPos.field_72448_b + t * (double)dy), (int)Math.round(startPos.field_72449_c + t * (double)dz));
            if (prevPos == p) continue;
            prevPos = p;
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos add = pool.add(p, x, y, z);
                        positions.add(add);
                    }
                }
            }
        }
        for (BlockPos position : positions) {
            if (worldIn.func_180495_p(position).func_177230_c() != Blocks.field_150480_ab) continue;
            worldIn.func_180498_a(playerIn, 1009, position, 0);
            worldIn.func_175698_g(position);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return Short.MAX_VALUE;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClickBase(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }
}

