/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crafter;

import ic2.core.block.machine.low.logic.crafter.CraftingRecipe;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class CraftList
implements IHasInventory {
    NonNullList<ItemStack> displayItems = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    CraftingRecipe[] recipes = new CraftingRecipe[27];
    Set<Integer> craftSlots = new LinkedHashSet<Integer>();

    public void validateRecipes(World world, boolean[] allowed) {
        Iterator<Integer> iter = this.craftSlots.iterator();
        while (iter.hasNext()) {
            int slot = iter.next();
            if (this.recipes[slot] == null) continue;
            if (!this.recipes[slot].validate(world)) {
                this.recipes[slot] = null;
                iter.remove();
                continue;
            }
            this.displayItems.set(slot, (Object)this.recipes[slot].getDisplayItem());
        }
    }

    public void saveRecipe(int slot, CraftingRecipe recipe) {
        this.recipes[slot] = recipe;
        this.displayItems.set(slot, (Object)this.recipes[slot].getDisplayItem());
        this.craftSlots.add(slot);
    }

    public void deleteRecipe(int slot) {
        if (this.craftSlots.remove(slot)) {
            this.displayItems.set(slot, (Object)ItemStack.field_190927_a);
            this.recipes[slot] = null;
        }
    }

    public CraftingRecipe getCopy(int index) {
        if (this.craftSlots.contains(index) && this.recipes[index] != null) {
            return this.recipes[index].copy();
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.displayItems = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        this.recipes = new CraftingRecipe[27];
        this.craftSlots.clear();
        NBTTagList list = nbt.func_150295_c("DataList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            CraftingRecipe recipe = new CraftingRecipe();
            recipe.readFromNBT(data);
            if (!recipe.isValidRecipe()) continue;
            int index = data.func_74762_e("ListIndex");
            this.craftSlots.add(index);
            this.recipes[index] = recipe;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Integer slot : this.craftSlots) {
            if (this.recipes[slot] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.recipes[slot].writeToNBT(data);
            data.func_74774_a("ListIndex", slot.byteValue());
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("DataList", (NBTBase)list);
    }

    public CraftingRecipe getFromFilter(IFilter filter) {
        if (this.craftSlots.size() == 0) {
            return null;
        }
        for (Integer slot : this.craftSlots) {
            if (!filter.matches((ItemStack)this.displayItems.get(slot.intValue()))) continue;
            return this.recipes[slot];
        }
        return null;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.displayItems.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.displayItems.get(slot);
    }

    @Override
    public int getSlotCount() {
        return 27;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }
}

