/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;

public class ItemReactorPlating
extends ItemIC2
implements ISteamReactorComponent,
IReactorPlannerComponent,
IBootable {
    public ItemReactorPlating() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setUnlocalizedName(Ic2ItemLang.reactorPlating);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2);
    }

    @Override
    public String getSheet(int meta) {
        return "i3";
    }

    @Override
    public int getTextureEntry(int meta) {
        return 48 + meta;
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (heatrun) {
            reactor.setMaxHeat(reactor.getMaxHeat() + this.getHeatModifier(stack.func_77960_j()));
            reactor.setHeatEffectModifier(reactor.getHeatEffectModifier() * this.getEffectModifier(stack.func_77960_j()));
        }
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return 0;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        float value = this.getEffectModifier(stack.func_77960_j());
        if (value >= 1.0f) {
            return 0.0f;
        }
        return value;
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        this.processChamber(yourStack, reactor, x, y, heatrun);
    }

    private int getHeatModifier(int meta) {
        switch (meta) {
            case 0: {
                return 1000;
            }
            case 1: {
                return 2000;
            }
            case 2: {
                return 500;
            }
        }
        return 0;
    }

    private float getEffectModifier(int meta) {
        switch (meta) {
            case 0: {
                return 0.95f;
            }
            case 1: {
                return 0.99f;
            }
            case 2: {
                return 0.9f;
            }
        }
        return 1.0f;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.reactorPlating;
            }
            case 1: {
                return Ic2ItemLang.reactorPlatingHeat;
            }
            case 2: {
                return Ic2ItemLang.reactorPlatingExplosive;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public void onLoad() {
        Ic2Items.reactorPlating = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorPlatingHeat = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorPlatingExplosive = new ItemStack((Item)this, 1, 2);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int meta = 0; meta < 3; ++meta) {
            items.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    @Override
    public ItemStack[] getSubParts() {
        return new ItemStack[]{new ItemStack((Item)this, 1, 0), new ItemStack((Item)this, 1, 1), new ItemStack((Item)this, 1, 2)};
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }

    @Override
    public short getID(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 0) {
            return 31;
        }
        if (meta == 1) {
            return 33;
        }
        if (meta == 2) {
            return 32;
        }
        return 0;
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.Plating;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat) {
            return new NBTTagInt(this.getHeatModifier(stack.func_77960_j()));
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

