/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.advancedsolars.blocks;

import ic2.api.item.ElectricItem;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.jetbrains.annotations.NotNull;
import trinsdar.advancedsolars.blocks.ContainerAdvancedSolarPanel;
import trinsdar.advancedsolars.util.AdvancedSolarLang;
import trinsdar.advancedsolars.util.Config;

public class TileEntityAdvancedSolarPanel
extends TileEntityGeneratorBase {
    double config;
    int ticker;
    protected double lowerProduction;
    int maxOutput;

    public TileEntityAdvancedSolarPanel() {
        super(4);
        this.tier = 1;
        this.ticker = 127;
        this.production = 8;
        this.lowerProduction = 1.0;
        this.maxStorage = 32000;
        this.maxOutput = 32;
        this.config = Config.energyGeneratorSolarAdvanced;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.None, RotationList.UP);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.UP.invert());
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{0, 1, 2, 3});
        handler.registerDefaultSlotsForSide(RotationList.DOWN, new int[]{0, 1, 2, 3});
        handler.registerInputFilter(CommonFilters.ChargeEU, new int[]{0, 1, 2, 3});
        handler.registerSlotType(SlotType.Charge, new int[]{0, 1, 2, 3});
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerAdvancedSolarPanel(player.field_71071_by, this);
    }

    public LocaleComp getBlockName() {
        return AdvancedSolarLang.advancedSolarPanel;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("advancedsolars", "textures/sprites/guiadvancedsolarpanel.png");
    }

    public int getMaxOutput() {
        return this.maxOutput;
    }

    public boolean isConverting() {
        if (this.skyBlockCheck()) {
            if (this.isSunVisible()) {
                return this.storage + this.production <= this.maxStorage;
            }
            return (double)this.storage + this.lowerProduction <= (double)this.maxStorage;
        }
        return false;
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            if (this.skyBlockCheck()) {
                this.storage = this.isSunVisible() ? (this.storage += this.production) : (int)((double)this.storage + this.lowerProduction);
            }
            return true;
        }
        return false;
    }

    public Box2D getEnergyBox() {
        return ContainerAdvancedSolarPanel.chargeBox;
    }

    public Vec2i getEnergyPos() {
        return ContainerAdvancedSolarPanel.chargePos;
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    public double getOfferedEnergy() {
        if (this.isSunVisible()) {
            return Math.min(this.storage, this.production);
        }
        return Math.min((double)this.storage, this.lowerProduction);
    }

    public void func_73660_a() {
        int oldEnergy = this.storage;
        boolean active = this.gainEnergy();
        if (this.storage > 0) {
            for (ItemStack tStack : this.inventory) {
                if (this.storage <= 0) break;
                if (tStack.func_190926_b()) continue;
                int charged = (int)ElectricItem.manager.charge(tStack, (double)this.storage, this.tier, false, false);
                this.storage -= charged;
            }
            if (this.storage > this.maxStorage) {
                this.storage = this.maxStorage;
            }
        }
        if (!this.delayActiveUpdate()) {
            this.setActive(active);
        } else {
            if (this.ticksSinceLastActiveUpdate % this.getDelay() == 0) {
                this.setActive(this.activityMeter > 0);
                this.activityMeter = 0;
            }
            this.activityMeter = active ? ++this.activityMeter : --this.activityMeter;
            ++this.ticksSinceLastActiveUpdate;
        }
        if (oldEnergy != this.storage) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "storage");
        }
        this.updateComparators();
    }

    public boolean gainFuel() {
        return false;
    }

    public int getOutput() {
        if (this.skyBlockCheck()) {
            if (this.isSunVisible()) {
                return (int)((double)this.production * this.config);
            }
            return (int)(this.lowerProduction * this.config);
        }
        return 0;
    }

    public boolean skyBlockCheck() {
        return this.func_145831_w().func_175710_j(this.func_174877_v().func_177984_a()) && this.func_145831_w().field_73011_w.func_191066_m();
    }

    public boolean isSunVisible() {
        return TileEntityAdvancedSolarPanel.isSunVisible(this.func_145831_w(), this.func_174877_v().func_177984_a());
    }

    public static boolean isSunVisible(@NotNull World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (world.func_72820_D() % 24000L < 12600L) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !biome.func_76738_d() || !world.func_72896_J() && !world.func_72911_I();
        }
        return false;
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public static class TileEntityUltimateHybridSolarPanel
    extends TileEntityAdvancedSolarPanel {
        public TileEntityUltimateHybridSolarPanel() {
            this.tier = 3;
            this.production = 512;
            this.lowerProduction = 64.0;
            this.maxStorage = 1000000;
            this.maxOutput = 512;
            this.config = Config.energyGeneratorSolarUltimateHybrid;
        }

        @Override
        public LocaleComp getBlockName() {
            return AdvancedSolarLang.ultimateHybridSolarPanel;
        }
    }

    public static class TileEntityHybridSolarPanel
    extends TileEntityAdvancedSolarPanel {
        public TileEntityHybridSolarPanel() {
            this.tier = 2;
            this.production = 64;
            this.lowerProduction = 8.0;
            this.maxStorage = 100000;
            this.maxOutput = 128;
            this.config = Config.energyGeneratorSolarHybrid;
        }

        @Override
        public LocaleComp getBlockName() {
            return AdvancedSolarLang.hybridSolarPanel;
        }
    }
}

