/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.google.common.base.Predicate;
import java.util.Random;
import mekanism.common.MekanismBlocks;
import mekanism.common.config.MekanismConfig;
import mekanism.common.world.WorldGenSalt;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class GenHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!(chunkGenerator instanceof ChunkGeneratorHell) && !(chunkGenerator instanceof ChunkGeneratorEnd)) {
            BlockPos pos;
            int i;
            for (i = 0; i < MekanismConfig.current().general.osmiumPerChunk.val(); ++i) {
                pos = new BlockPos(chunkX * 16 + random.nextInt(16), random.nextInt(60), chunkZ * 16 + random.nextInt(16));
                new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(0), MekanismConfig.current().general.osmiumMaxVeinSize.val(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, random, pos);
            }
            for (i = 0; i < MekanismConfig.current().general.copperPerChunk.val(); ++i) {
                pos = new BlockPos(chunkX * 16 + random.nextInt(16), random.nextInt(60), chunkZ * 16 + random.nextInt(16));
                new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(1), MekanismConfig.current().general.copperMaxVeinSize.val(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, random, pos);
            }
            for (i = 0; i < MekanismConfig.current().general.tinPerChunk.val(); ++i) {
                pos = new BlockPos(chunkX * 16 + random.nextInt(16), random.nextInt(60), chunkZ * 16 + random.nextInt(16));
                new WorldGenMinable(MekanismBlocks.OreBlock.func_176203_a(2), MekanismConfig.current().general.tinMaxVeinSize.val(), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, random, pos);
            }
            for (i = 0; i < MekanismConfig.current().general.saltPerChunk.val(); ++i) {
                int randPosX = chunkX * 16 + random.nextInt(16) + 8;
                int randPosZ = chunkZ * 16 + random.nextInt(16) + 8;
                BlockPos pos2 = world.func_175672_r(new BlockPos(randPosX, 60, randPosZ));
                new WorldGenSalt(MekanismConfig.current().general.saltMaxVeinSize.val()).func_180709_b(world, random, pos2);
            }
        }
    }
}

