/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.generator;

import nc.block.tile.BlockTile;
import nc.block.tile.IActivatable;
import nc.init.NCBlocks;
import nc.tab.NCTabs;
import nc.tile.generator.TileFusionCore;
import nc.util.BlockPosHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFusionCore
extends BlockTile
implements IActivatable {
    public BlockFusionCore() {
        super("fusion_core", Material.field_151574_g);
        this.func_149647_a(NCTabs.FUSION);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileFusionCore();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 3.0, 2.0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.cuboid(-1, 0, -1, 1, 2, 1)) {
            if (BlockFusionCore.isAir(world, blockPos)) continue;
            return false;
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.squareRing(1, 0)) {
            BlockFusionCore.setSide(world, blockPos);
        }
        for (BlockPos blockPos : helper.cuboid(-1, 1, -1, 1, 1, 1)) {
            BlockFusionCore.setSide(world, blockPos);
        }
        for (BlockPos blockPos : helper.cuboid(-1, 2, -1, 1, 2, 1)) {
            BlockFusionCore.setTop(world, blockPos);
        }
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.squareRing(1, 0)) {
            BlockFusionCore.setAir(world, blockPos);
        }
        for (BlockPos blockPos : helper.cuboid(-1, 1, -1, 1, 2, 1)) {
            BlockFusionCore.setAir(world, blockPos);
        }
        world.func_175713_t(pos);
    }

    private static boolean isAir(World world, BlockPos pos) {
        Material mat = world.func_180495_p(pos).func_185904_a();
        return mat == Material.field_151579_a || mat == Material.field_151581_o || mat == Material.field_151586_h || mat == Material.field_151582_l || mat == Material.field_151597_y;
    }

    private static void setAir(World world, BlockPos pos) {
        world.func_175655_b(pos, false);
    }

    private static void setSide(World world, BlockPos pos) {
        IBlockState dummy = NCBlocks.fusion_dummy_side.func_176223_P();
        world.func_175656_a(pos, dummy);
    }

    private static void setTop(World world, BlockPos pos) {
        IBlockState dummy = NCBlocks.fusion_dummy_top.func_176223_P();
        world.func_175656_a(pos, dummy);
    }

    @Override
    public void setState(boolean active, World world, BlockPos pos) {
    }

    @Override
    public void onGuiOpened(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFusionCore) {
            ((TileFusionCore)tile).refreshMultiblock();
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFusionCore) {
            return ((TileFusionCore)tile).getComparatorStrength();
        }
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }
}

