/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.api.config.Settings;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.ITooltip;
import appeng.client.render.StackSizeRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.container.ContainerBase;
import thaumicenergistics.container.slot.ISlotOptional;
import thaumicenergistics.container.slot.SlotGhostEssentia;
import thaumicenergistics.container.slot.SlotME;
import thaumicenergistics.container.slot.ThESlot;

public abstract class GuiBase
extends GuiContainer {
    private static StackSizeRenderer stackSizeRenderer = new StackSizeRenderer();

    public GuiBase(ContainerBase container) {
        super((Container)container);
    }

    public void reload() {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void func_146977_a(Slot slot) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getGuiBackground());
        if (slot instanceof ISlotOptional) {
            if (slot.func_111238_b()) {
                // empty if block
            }
        } else {
            if (slot instanceof SlotME && ((SlotME)slot).getAEStack() instanceof IAEItemStack) {
                SlotME slotME = (SlotME)slot;
                super.func_146977_a(slot);
                stackSizeRenderer.renderStackSize(this.field_146289_q, (IAEItemStack)slotME.getAEStack(), slot.field_75223_e, slot.field_75221_f);
                return;
            }
            if (slot instanceof ThESlot && ((ThESlot)slot).hasBackgroundIcon()) {
                int index = ((ThESlot)slot).getBackgroundIconIndex();
                int uv_y = (int)Math.floor((double)index / 16.0);
                int uv_x = index - uv_y * 16;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(((ThESlot)slot).getBackgroundIcon());
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_179098_w();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawTexturedModelRectColor(slot.field_75223_e, slot.field_75221_f, uv_x * 16, uv_y * 16, 16, 16, new Color(1.0f, 1.0f, 1.0f, 0.4f));
            }
        }
        super.func_146977_a(slot);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.field_147006_u != null) {
            if (this.field_147006_u instanceof SlotGhostEssentia && ((SlotGhostEssentia)this.field_147006_u).getAspect() != null) {
                this.func_146279_a(((SlotGhostEssentia)this.field_147006_u).getAspect().getName(), mouseX, mouseY);
                return;
            }
            if (this.field_147006_u instanceof SlotME && this.field_147006_u.func_75216_d() && ((SlotME)this.field_147006_u).getAEStack() instanceof IAEEssentiaStack) {
                IAEEssentiaStack stack = (IAEEssentiaStack)((SlotME)this.field_147006_u).getAEStack();
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(stack.getAspect().getName());
                tooltip.add(Long.toString(stack.getStackSize()));
                this.func_146283_a(tooltip, mouseX, mouseY);
                return;
            }
        }
        for (GuiButton c : this.field_146292_n) {
            if (!(c instanceof ITooltip) || !((ITooltip)c).isVisible()) continue;
            ITooltip t = (ITooltip)c;
            int x = t.xPos();
            int y = t.yPos();
            if (mouseX < x || mouseX > x + t.getWidth() || mouseY < y || mouseY > y + t.getHeight() || t.getMessage() == null || t.getMessage().isEmpty()) continue;
            if (y < 15) {
                y = 15;
            }
            List<String> lines = Arrays.asList(t.getMessage().split("\n"));
            lines.set(0, TextFormatting.WHITE + lines.get(0));
            for (int i = 1; i < lines.size(); ++i) {
                lines.set(i, TextFormatting.GRAY + lines.get(i));
            }
            this.drawHoveringText(lines, x + 11, y + 4, this.field_146289_q);
        }
        super.func_191948_b(mouseX, mouseY);
    }

    public void updateSetting(Settings setting, Enum value) {
        if (this.field_147002_h instanceof IConfigurableObject) {
            IConfigManager configManager = ((IConfigurableObject)this.field_147002_h).getConfigManager();
            configManager.putSetting(setting, value);
            this.field_146292_n.forEach(btn -> {
                if (!(btn instanceof GuiImgButton)) {
                    return;
                }
                GuiImgButton b = (GuiImgButton)btn;
                if (b.getSetting() == Settings.ACTIONS || b.getSetting() == Settings.TERMINAL_STYLE) {
                    return;
                }
                b.set(configManager.getSetting(b.getSetting()));
            });
        }
    }

    protected void addMESlot(SlotME slot) {
        slot.field_75222_d = this.field_147002_h.field_75151_b.size();
        this.field_147002_h.field_75151_b.add(slot);
        this.field_147002_h.field_75153_a.add((Object)ItemStack.field_190927_a);
    }

    protected abstract ResourceLocation getGuiBackground();

    protected void drawTexturedModelRectColor(int x, int y, int textureX, int textureY, int width, int height, Color color) {
        float offsetX = 0.00390625f;
        float offsetY = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buf.func_181662_b((double)x, (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)textureX * offsetX), (double)((float)(textureY + height) * offsetY)).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buf.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * offsetX), (double)((float)(textureY + height) * offsetY)).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buf.func_181662_b((double)(x + width), (double)y, (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * offsetX), (double)((float)textureY * offsetY)).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        buf.func_181662_b((double)x, (double)y, (double)this.field_73735_i).func_187315_a((double)((float)textureX * offsetX), (double)((float)textureY * offsetY)).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        tess.func_78381_a();
    }
}

