/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.blocks;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRail;
import cam72cam.immersiverailroading.blocks.PropertyEnum;
import cam72cam.immersiverailroading.blocks.PropertyItemStack;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.tile.SyncdTileEntity;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.util.SwitchUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockRailBase
extends Block {
    public static final PropertyItemStack RAIL_BED = new PropertyItemStack("RAIL_BED");
    public static final PropertyFloat HEIGHT = new PropertyFloat("HEIGHT");
    public static final PropertyFloat SNOW = new PropertyFloat("SNOW");
    public static final PropertyFloat GAUGE = new PropertyFloat("GAUGE");
    public static final PropertyEnum<Augment> AUGMENT = new PropertyEnum<Augment>("AUGMENT", Augment.class);
    public static final PropertyFloat LIQUID = new PropertyFloat("LIQUID");
    public static final PropertyEnum<EnumFacing> FACING = new PropertyEnum<EnumFacing>("FACING", EnumFacing.class);

    public BlockRailBase() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(ItemTabs.MAIN_TAB);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(IRItems.ITEM_TRACK_BLUEPRINT, 1);
        TileRailBase rail = TileRailBase.get((IBlockAccess)world, pos);
        if (rail == null || !rail.isLoaded()) {
            return stack;
        }
        TileRail parent = rail.getParentTile();
        if (parent == null || !parent.isLoaded()) {
            return stack;
        }
        ItemTrackBlueprint.settings(stack, parent.info.settings);
        return stack;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileRailBase te = TileRailBase.get((IBlockAccess)world, pos);
        if (te != null) {
            if (te instanceof TileRail) {
                ((TileRail)te).spawnDrops();
            }
            BlockRailBase.breakParentIfExists(te);
            world.func_147457_a((TileEntity)te);
        }
    }

    public static void breakParentIfExists(TileRailBase te) {
        BlockPos parent = te.getParent();
        if (parent != null && !te.getWillBeReplaced() && te.func_145831_w().func_180495_p(parent).func_177230_c() instanceof BlockRail) {
            if (te.getParentTile() != null) {
                te.getParentTile().spawnDrops();
            }
            te.func_145831_w().func_175698_g(parent);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{RAIL_BED, HEIGHT, SNOW, GAUGE, AUGMENT, LIQUID, FACING});
    }

    public IBlockState getExtendedState(IBlockState origState, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)origState;
        TileRailBase te = TileRailBase.get(world, pos);
        if (te != null && te.getRenderRailBed() != null) {
            state = state.withProperty((IUnlistedProperty)RAIL_BED, (Object)te.getRenderRailBed());
            state = state.withProperty((IUnlistedProperty)HEIGHT, (Object)Float.valueOf(te.getBedHeight()));
            state = state.withProperty((IUnlistedProperty)SNOW, (Object)Float.valueOf(te.getSnowLayers()));
            state = state.withProperty((IUnlistedProperty)GAUGE, (Object)Float.valueOf((float)te.getRenderGauge()));
            state = state.withProperty(AUGMENT, (Object)te.getAugment());
            state = state.withProperty((IUnlistedProperty)LIQUID, (Object)Float.valueOf((float)te.getTankLevel()));
            TileRail parent = te.getParentTile();
            if (parent != null) {
                if (parent.info.placementInfo.facing().func_176740_k() == EnumFacing.Axis.X && parent.func_174877_v().func_177952_p() == te.func_174877_v().func_177952_p()) {
                    state = state.withProperty(FACING, (Object)te.getParentTile().info.placementInfo.facing());
                }
                if (parent.info.placementInfo.facing().func_176740_k() == EnumFacing.Axis.Z && parent.func_174877_v().func_177958_n() == te.func_174877_v().func_177958_n()) {
                    state = state.withProperty(FACING, (Object)te.getParentTile().info.placementInfo.facing());
                }
            }
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChange((IBlockAccess)worldIn, pos, fromPos);
    }

    public static boolean tryBreakRail(IBlockAccess world, BlockPos pos) {
        block6: {
            try {
                TileRailBase rail = TileRailBase.get(world, pos);
                if (rail != null && rail.getReplaced() != null) {
                    TileRailGag newGag = new TileRailGag();
                    newGag.func_145839_a(rail.getReplaced());
                    while (true) {
                        if (newGag.getParent() != null && TileRailBase.get(world, newGag.getParent()) != null) {
                            rail.func_145831_w().func_175690_a(pos, (TileEntity)newGag);
                            newGag.func_70296_d();
                            BlockRailBase.breakParentIfExists(rail);
                            return false;
                        }
                        NBTTagCompound data = newGag.getReplaced();
                        if (data != null) {
                            newGag = new TileRailGag();
                            newGag.func_145839_a(data);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (StackOverflowError ex) {
                ImmersiveRailroading.error("Invalid recursive rail block at %s", pos);
                ImmersiveRailroading.catching(ex);
                TileRailBase rail = TileRailBase.get(world, pos);
                if (rail == null) break block6;
                rail.func_145831_w().func_175698_g(pos);
            }
        }
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileRailBase tileEntity;
        SyncdTileEntity syncd = SyncdTileEntity.get(world, pos, Chunk.EnumCreateEntityType.CHECK);
        TileRailBase tileRailBase = tileEntity = syncd instanceof TileRailBase ? (TileRailBase)syncd : null;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        tileEntity.blockUpdate = true;
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        if (up.func_177230_c() == Blocks.field_150431_aC && tileEntity.handleSnowTick()) {
            tileEntity.func_145831_w().func_175698_g(pos.func_177984_a());
        }
        NBTTagCompound data = tileEntity.getReplaced();
        while (true) {
            if (tileEntity.getParentTile() != null && tileEntity.getParentTile().getParentTile() != null) {
                SwitchState state;
                TileRail switchTile = tileEntity.getParentTile();
                if (tileEntity instanceof TileRail) {
                    switchTile = (TileRail)tileEntity;
                }
                if ((state = SwitchUtil.getSwitchState(switchTile)) != SwitchState.NONE) {
                    switchTile.setSwitchState(state);
                }
            }
            if (data == null) break;
            tileEntity = new TileRailBase();
            tileEntity.func_145839_a(data);
            tileEntity.func_145834_a(syncd.func_145831_w());
            data = tileEntity.getReplaced();
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileRailBase te = TileRailBase.get(source, pos);
        double height = 0.1;
        if (te != null && te.isLoaded()) {
            height = (double)te.getFullHeight() + 0.1 * (te.getTrackGauge() / 1.435);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, height, 1.0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileRailBase te = TileRailBase.get(source, pos);
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, Math.max(te == null ? 0.0 : (double)te.getFullHeight(), 0.25), 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_180646_a(state, (IBlockAccess)worldIn, pos).func_72321_a(0.0, 0.1, 0.0).func_186670_a(pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        if (p_193383_4_ == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        TileRailBase te = TileRailBase.get((IBlockAccess)worldIn, pos);
        if (te != null) {
            String next;
            TileRail tileSwitch;
            if (stack.func_77973_b() == IRItems.ITEM_SWITCH_KEY && (tileSwitch = te.findSwitchParent()) != null) {
                SwitchState switchForced = te.cycleSwitchForced();
                if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)(switchForced.equals((Object)SwitchState.NONE) ? new TextComponentString(ChatText.SWITCH_UNLOCKED.toString()) : ChatText.SWITCH_LOCKED.getMessage(switchForced.toString())));
                }
            }
            if (block == Blocks.field_150429_aA && (next = te.nextAugmentRedstoneMode()) != null) {
                if (!worldIn.field_72995_K) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(next));
                }
                return true;
            }
            if (block == Blocks.field_150431_aC) {
                if (!worldIn.field_72995_K) {
                    te.handleSnowTick();
                }
                return true;
            }
            if (block == Blocks.field_150433_aE) {
                if (!worldIn.field_72995_K) {
                    for (int i = 0; i < 8; ++i) {
                        te.handleSnowTick();
                    }
                }
                return true;
            }
            if (stack.func_77973_b().getToolClasses(stack).contains("shovel") && !worldIn.field_72995_K) {
                te.cleanSnow();
                te.setSnowLayers(0);
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileRailBase te = TileRailBase.get(blockAccess, pos);
        if (te != null && te.getAugment() == Augment.DETECTOR) {
            return te.getRedstoneLevel();
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

