/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.StockDeathType;
import cam72cam.immersiverailroading.net.PassengerPositionsPacket;
import cam72cam.immersiverailroading.util.BufferUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class EntityRidableRollingStock
extends EntityBuildableRollingStock {
    public Map<UUID, Vec3d> passengerPositions = new HashMap<UUID, Vec3d>();
    public Map<Integer, Vec3d> dismounts = new HashMap<Integer, Vec3d>();
    private final double pressDist = 0.05;
    public List<StaticPassenger> staticPassengers = new ArrayList<StaticPassenger>();

    public EntityRidableRollingStock(World world, String defID) {
        super(world, defID);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        this.passengerPositions = BufferUtil.readPlayerPositions(additionalData);
        this.staticPassengers = BufferUtil.readStaticPassengers(additionalData);
        super.readSpawnData(additionalData);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        BufferUtil.writePlayerPositions(buffer, this.passengerPositions);
        BufferUtil.writeStaticPassengers(buffer, this.staticPassengers);
        super.writeSpawnData(buffer);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.passengerPositions.size() > 0) {
            NBTTagCompound offsetTag = nbttagcompound.func_74775_l("passengerOffsets");
            ArrayList<String> passengers = new ArrayList<String>();
            for (UUID uUID : this.passengerPositions.keySet()) {
                passengers.add(uUID.toString());
                offsetTag.func_74780_a(uUID.toString() + ".x", this.passengerPositions.get((Object)uUID).field_72450_a);
                offsetTag.func_74780_a(uUID.toString() + ".y", this.passengerPositions.get((Object)uUID).field_72448_b);
                offsetTag.func_74780_a(uUID.toString() + ".z", this.passengerPositions.get((Object)uUID).field_72449_c);
            }
            offsetTag.func_74778_a("passengers", String.join((CharSequence)"|", passengers));
            nbttagcompound.func_74782_a("passengerOffsets", (NBTBase)offsetTag);
        }
        if (this.staticPassengers.size() > 0) {
            NBTTagCompound passengers = nbttagcompound.func_74775_l("staticPassengers");
            passengers.func_74768_a("count", this.staticPassengers.size());
            int i = 0;
            for (StaticPassenger staticPassenger : this.staticPassengers) {
                passengers.func_74782_a("" + i, (NBTBase)staticPassenger.writeNBT());
                ++i;
            }
            nbttagcompound.func_74782_a("staticPassengers", (NBTBase)passengers);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("passengerOffsets")) {
            NBTTagCompound offsetTag = nbttagcompound.func_74775_l("passengerOffsets");
            for (String passenger : offsetTag.func_74779_i("passengers").split("\\|")) {
                Vec3d pos = new Vec3d(offsetTag.func_74769_h(passenger + ".x"), offsetTag.func_74769_h(passenger + ".y"), offsetTag.func_74769_h(passenger + ".z"));
                this.passengerPositions.put(UUID.fromString(passenger), pos);
            }
        }
        if (nbttagcompound.func_74764_b("staticPassengers")) {
            NBTTagCompound passengers = nbttagcompound.func_74775_l("staticPassengers");
            int count = passengers.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                this.staticPassengers.add(new StaticPassenger(passengers.func_74775_l("" + i)));
            }
        }
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_184218_aH() && player.func_184187_bx().getPersistentID() == this.getPersistentID()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.passengerPositions.put(player.getPersistentID(), new Vec3d(0.0, 0.0, 0.0));
            this.sendToObserving(new PassengerPositionsPacket(this));
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() + this.staticPassengers.size() < this.getDefinition().getMaxPassengers();
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        if (this.getDefinition().shouldSit != null) {
            return this.getDefinition().shouldSit;
        }
        return this.gauge.shouldSit();
    }

    public void handleKeyPress(Entity source, KeyTypes key, boolean sprinting) {
        Vec3d movement = null;
        switch (key) {
            case PLAYER_FORWARD: {
                movement = new Vec3d(0.05, 0.0, 0.0);
                break;
            }
            case PLAYER_BACKWARD: {
                movement = new Vec3d(-0.05, 0.0, 0.0);
                break;
            }
            case PLAYER_LEFT: {
                movement = new Vec3d(0.0, 0.0, -0.05);
                break;
            }
            case PLAYER_RIGHT: {
                movement = new Vec3d(0.0, 0.0, 0.05);
                break;
            }
            default: {
                return;
            }
        }
        if (source.func_184187_bx() == this) {
            if (sprinting) {
                movement = movement.func_186678_a(3.0);
            }
            movement = VecUtil.rotateWrongYaw(movement, source.func_70079_am());
            movement = VecUtil.rotateWrongYaw(movement, 180.0f - this.field_70177_z);
            Vec3d pos = this.passengerPositions.get(source.getPersistentID()).func_178787_e(movement);
            if (this instanceof EntityCoupleableRollingStock) {
                if (this.getDefinition().isAtFront(this.gauge, pos) && ((EntityCoupleableRollingStock)this).isCoupled(EntityCoupleableRollingStock.CouplerType.FRONT)) {
                    source.func_184220_m((Entity)((EntityCoupleableRollingStock)this).getCoupled(EntityCoupleableRollingStock.CouplerType.FRONT));
                    return;
                }
                if (this.getDefinition().isAtRear(this.gauge, pos) && ((EntityCoupleableRollingStock)this).isCoupled(EntityCoupleableRollingStock.CouplerType.BACK)) {
                    source.func_184220_m((Entity)((EntityCoupleableRollingStock)this).getCoupled(EntityCoupleableRollingStock.CouplerType.BACK));
                    return;
                }
            }
            pos = this.getDefinition().correctPassengerBounds(this.gauge, pos);
            this.passengerPositions.put(source.getPersistentID(), pos);
            this.sendToObserving(new PassengerPositionsPacket(this));
        }
    }

    protected void func_184200_o(Entity passenger) {
        Vec3d ppos = new Vec3d(passenger.field_70142_S, passenger.field_70137_T, passenger.field_70136_U);
        super.func_184200_o(passenger);
        if (!this.field_70170_p.field_72995_K) {
            Vec3d center = this.getDefinition().getPassengerCenter(this.gauge);
            center = VecUtil.rotateWrongYaw(center, this.field_70177_z);
            center = center.func_178787_e(this.func_174791_d());
            Vec3d off = VecUtil.rotateWrongYaw(center.func_178788_d(ppos), -this.field_70177_z);
            off = this.getDefinition().correctPassengerBounds(this.gauge, off);
            off = off.func_72441_c(0.0, -off.field_72448_b, 0.0);
            this.passengerPositions.put(passenger.getPersistentID(), off);
            this.func_184232_k(passenger);
            this.sendToObserving(new PassengerPositionsPacket(this));
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger) && this.passengerPositions.containsKey(passenger.getPersistentID())) {
            Vec3d pos = this.getDefinition().getPassengerCenter(this.gauge);
            Vec3d ppos = this.passengerPositions.get(passenger.getPersistentID());
            pos = pos.func_178787_e(ppos);
            pos = VecUtil.rotatePitch(pos, this.field_70125_A);
            pos = VecUtil.rotateWrongYaw(pos, this.field_70177_z);
            pos = pos.func_178787_e(this.func_174791_d());
            if (passenger instanceof EntityPlayer && this.shouldRiderSit()) {
                pos = pos.func_178786_a(0.0, 0.75, 0.0);
            }
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            passenger.field_70159_w = this.field_70159_w;
            passenger.field_70181_x = this.field_70181_x;
            passenger.field_70179_y = this.field_70179_y;
            passenger.field_70126_B = passenger.field_70177_z;
            passenger.field_70177_z += this.field_70177_z - this.field_70126_B;
        }
    }

    public void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (this.passengerPositions.containsKey(passenger.getPersistentID())) {
            Vec3d ppos = this.passengerPositions.get(passenger.getPersistentID());
            Vec3d delta = this.dismountPos(ppos);
            passenger.func_70634_a(delta.field_72450_a, passenger.field_70163_u, delta.field_72449_c);
            if (!this.field_70170_p.field_72995_K) {
                this.dismounts.put(passenger.func_145782_y(), new Vec3d(delta.field_72450_a, passenger.field_70163_u, delta.field_72449_c));
                this.passengerPositions.remove(passenger.getPersistentID());
                this.sendToObserving(new PassengerPositionsPacket(this));
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            for (Integer id : this.dismounts.keySet()) {
                Entity ent = this.field_70170_p.func_73045_a(id.intValue());
                if (ent == null) continue;
                Vec3d pos = this.dismounts.get(id);
                ent.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            }
            this.dismounts.clear();
        }
    }

    public Vec3d dismountPos(Vec3d ppos) {
        Vec3d pos = this.getDefinition().getPassengerCenter(this.gauge);
        pos = pos.func_178787_e(ppos);
        pos = VecUtil.rotateWrongYaw(pos, this.field_70177_z);
        pos = pos.func_178787_e(this.func_174791_d());
        Vec3d delta = VecUtil.fromWrongYaw(this.getDefinition().getPassengerCompartmentWidth(this.gauge) / 2.0 + 1.3 * this.gauge.scale(), this.field_70177_z + (float)(ppos.field_72449_c > 0.0 ? 90 : -90));
        return delta.func_178787_e(pos);
    }

    public void handlePassengerPositions(Map<UUID, Vec3d> passengerPositions) {
        this.passengerPositions = passengerPositions;
        for (Entity passenger : this.func_184188_bt()) {
            this.func_184232_k(passenger);
        }
    }

    public void addStaticPassenger(EntityLiving entityliving, Vec3d pos) {
        StaticPassenger sp = new StaticPassenger(entityliving);
        this.staticPassengers.add(sp);
        Vec3d center = this.getDefinition().getPassengerCenter(this.gauge);
        center = VecUtil.rotateWrongYaw(center, this.field_70177_z);
        center = center.func_178787_e(this.func_174791_d());
        Vec3d off = VecUtil.rotateWrongYaw(center.func_178788_d(pos), -this.field_70177_z);
        off = this.getDefinition().correctPassengerBounds(this.gauge, off);
        int wiggle = sp.isVillager ? 10 : 2;
        off = off.func_72441_c((Math.random() - 0.5) * (double)wiggle, 0.0, (Math.random() - 0.5) * (double)wiggle);
        off = this.getDefinition().correctPassengerBounds(this.gauge, off);
        off = off.func_72441_c(0.0, -off.field_72448_b, 0.0);
        this.passengerPositions.put(sp.uuid, off);
        this.sendToObserving(new PassengerPositionsPacket(this));
        entityliving.func_70106_y();
    }

    public EntityLiving removeStaticPasssenger(Vec3d pos, boolean isVillager) {
        if (this.staticPassengers.size() > 0) {
            int index = -1;
            for (int i = this.staticPassengers.size() - 1; i >= 0; --i) {
                if (this.staticPassengers.get((int)i).isVillager != isVillager) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return null;
            }
            StaticPassenger passenger = this.staticPassengers.get(index);
            this.staticPassengers.remove(index);
            Vec3d ppos = this.passengerPositions.remove(passenger.uuid);
            this.sendToObserving(new PassengerPositionsPacket(this));
            if (passenger.isVillager) {
                ppos = this.dismountPos(ppos).func_72441_c(0.0, 1.0, 0.0);
                double distanceMoved = pos.func_72438_d(new Vec3d((Vec3i)passenger.startPos));
                int payout = (int)Math.floor(distanceMoved * Config.ConfigBalance.villagerPayoutPerMeter);
                List<Item> payouts = Config.ConfigBalance.getVillagerPayout();
                if (payouts.size() != 0) {
                    int type = (int)(Math.random() * 100.0) % payouts.size();
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, new ItemStack(payouts.get(type), payout)));
                }
                pos = ppos;
            }
            EntityLiving ent = passenger.respawn(this.field_70170_p, pos);
            this.field_70170_p.func_72838_d((Entity)ent);
            return ent;
        }
        return null;
    }

    @Override
    public void onDeath(StockDeathType type) {
        super.onDeath(type);
        while (this.removeStaticPasssenger(this.func_174791_d(), true) != null) {
        }
        while (this.removeStaticPasssenger(this.func_174791_d(), false) != null) {
        }
    }

    public static class StaticPassenger {
        public ResourceLocation ident;
        public NBTTagCompound data;
        public UUID uuid;
        public float rotation;
        private BlockPos startPos;
        public boolean isVillager;
        public Object cache;

        public StaticPassenger(EntityLiving entityliving) {
            this.ident = EntityList.func_191301_a((Entity)entityliving);
            this.data = entityliving.func_189511_e(new NBTTagCompound());
            this.uuid = entityliving.getPersistentID();
            this.startPos = entityliving.func_180425_c();
            this.isVillager = entityliving instanceof EntityVillager;
            this.rotation = (float)(Math.random() * 360.0);
        }

        public StaticPassenger(NBTTagCompound init) {
            this.ident = new ResourceLocation(init.func_74779_i("ident"));
            this.data = init.func_74775_l("data");
            this.uuid = UUID.fromString(init.func_74779_i("uuid"));
            this.rotation = init.func_74760_g("rotation");
            this.startPos = NBTUtil.func_186861_c((NBTTagCompound)init.func_74775_l("pos"));
            this.isVillager = init.func_74767_n("isVillager");
        }

        public NBTTagCompound writeNBT() {
            NBTTagCompound init = new NBTTagCompound();
            init.func_74778_a("ident", this.ident.toString());
            init.func_74782_a("data", (NBTBase)this.data);
            init.func_74778_a("uuid", this.uuid.toString());
            init.func_74776_a("rotation", this.rotation);
            init.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.startPos));
            init.func_74757_a("isVillager", this.isVillager);
            return init;
        }

        public EntityLiving respawn(World world, Vec3d pos) {
            Entity ent = EntityList.func_188429_b((ResourceLocation)this.ident, (World)world);
            ent.func_70020_e(this.data);
            ent.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            return (EntityLiving)ent;
        }
    }
}

