/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class GUIHelpers {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");

    public static void drawRect(double x, double y, double width, double height, int color) {
        double zLevel = 0.0;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)f3);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(x + 0.0, y + height, zLevel).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, zLevel).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + 0.0, zLevel).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y + 0.0, zLevel).func_181675_d();
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void texturedRect(double x, double y, double width, double height) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawFluid(Fluid fluid, double x, double d, double width, int height, int scale) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
        if (sprite != null) {
            GUIHelpers.drawSprite(sprite, fluid.getColor(), x, d, width, height, scale);
        }
    }

    public static void drawSprite(TextureAtlasSprite sprite, int col, double x, double y, double width, double height, int scale) {
        double zLevel = 0.0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
        int iW = sprite.func_94211_a() * scale;
        int iH = sprite.func_94216_b() * scale;
        float minU = sprite.func_94209_e();
        float minV = sprite.func_94206_g();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int offY = 0;
        while ((double)offY < height) {
            double curHeight = Math.min((double)iH, height - (double)offY);
            float maxVScaled = sprite.func_94207_b(16.0 * curHeight / (double)iH);
            int offX = 0;
            while ((double)offX < width) {
                double curWidth = Math.min((double)iW, width - (double)offX);
                float maxUScaled = sprite.func_94214_a(16.0 * curWidth / (double)iW);
                buffer.func_181662_b(x + (double)offX, y + (double)offY, zLevel).func_187315_a((double)minU, (double)minV).func_181675_d();
                buffer.func_181662_b(x + (double)offX, y + (double)offY + curHeight, zLevel).func_187315_a((double)minU, (double)maxVScaled).func_181675_d();
                buffer.func_181662_b(x + (double)offX + curWidth, y + (double)offY + curHeight, zLevel).func_187315_a((double)maxUScaled, (double)maxVScaled).func_181675_d();
                buffer.func_181662_b(x + (double)offX + curWidth, y + (double)offY, zLevel).func_187315_a((double)maxUScaled, (double)minV).func_181675_d();
                offX += iW;
            }
            offY += iH;
        }
        tessellator.func_78381_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
    }

    public static void drawTankBlock(double x, double y, double width, double height, Fluid fluid, float percentFull) {
        GUIHelpers.drawTankBlock(x, y, width, height, fluid, percentFull, true, 0);
    }

    public static void drawTankBlock(double x, double y, double width, double height, Fluid fluid, float percentFull, boolean drawBackground, int color) {
        if (drawBackground) {
            GUIHelpers.drawRect(x, y, width, height, -16777216);
        }
        if (percentFull > 0.0f && fluid != null) {
            int fullHeight = Math.max(1, (int)(height * (double)percentFull));
            GUIHelpers.drawFluid(fluid, x, y + height - (double)fullHeight, width, fullHeight, 2);
            GUIHelpers.drawRect(x, y + height - (double)fullHeight, width, fullHeight, color);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

