/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.CraftPicker;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemPlateType;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlateRollerGUI
extends GuiScreen {
    private GuiButton gaugeButton;
    private Gauge gauge;
    private GuiButton plateButton;
    private PlateType plate;
    private GuiButton pickerButton;
    private CraftPicker picker;
    private TileMultiblock tile;
    private ItemStack currentItem;

    public PlateRollerGUI(TileMultiblock te) {
        this.tile = te;
        this.currentItem = te.getCraftItem();
        if (this.currentItem == null || this.currentItem.func_190926_b()) {
            this.currentItem = new ItemStack((Item)IRItems.ITEM_PLATE, 1);
        }
        this.gauge = ItemGauge.get(this.currentItem);
        this.plate = ItemPlateType.get(this.currentItem);
        this.picker = new CraftPicker(null, CraftingType.PLATE_BOILER, item -> {
            this.field_146297_k.func_147108_a((GuiScreen)this);
            if (item != null) {
                String defID = ItemDefinition.getID(item);
                ItemDefinition.setID(this.currentItem, defID);
                EntityRollingStockDefinition def = ItemDefinition.get(this.currentItem);
                if (def != null && !this.gauge.isModel() && this.gauge.value() != def.recommended_gauge.value()) {
                    this.gauge = def.recommended_gauge;
                    this.gaugeButton.field_146126_j = GuiText.SELECTOR_GAUGE.toString(this.gauge);
                }
                this.updatePickerButton();
                this.sendPacket();
            }
        });
    }

    private void updatePickerButton() {
        EntityRollingStockDefinition def = ItemDefinition.get(this.currentItem.func_77946_l());
        if (def != null) {
            this.pickerButton.field_146126_j = GuiText.SELECTOR_PLATE_BOILER.toString(def.name());
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        int buttonID = 0;
        this.gaugeButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_GAUGE.toString(this.gauge));
        this.field_146292_n.add(this.gaugeButton);
        this.plateButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_PLATE_TYPE.toString(new Object[]{this.plate}));
        this.field_146292_n.add(this.plateButton);
        this.pickerButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_PLATE_BOILER.toString(""));
        this.pickerButton.field_146125_m = this.plate == PlateType.BOILER;
        this.updatePickerButton();
        this.field_146292_n.add(this.pickerButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.gaugeButton) {
            if (!this.currentItem.func_190926_b()) {
                EntityRollingStockDefinition def = ItemDefinition.get(this.currentItem);
                if (def != null && this.plate == PlateType.BOILER && Config.ConfigBalance.DesignGaugeLock) {
                    ArrayList<Gauge> validGauges = new ArrayList<Gauge>();
                    validGauges.add(Gauge.from(def.recommended_gauge.value()));
                    this.gauge = this.gauge.next(validGauges);
                } else {
                    this.gauge = this.gauge.next();
                }
            }
            this.gaugeButton.field_146126_j = GuiText.SELECTOR_GAUGE.toString(this.gauge);
            this.sendPacket();
        }
        if (button == this.plateButton) {
            this.plate = PlateType.values()[(this.plate.ordinal() + 1) % PlateType.values().length];
            this.plateButton.field_146126_j = GuiText.SELECTOR_PLATE_TYPE.toString(new Object[]{this.plate});
            this.pickerButton.field_146125_m = this.plate == PlateType.BOILER;
            this.sendPacket();
        }
        if (button == this.pickerButton) {
            this.field_146297_k.func_147108_a((GuiScreen)this.picker);
        }
    }

    private void sendPacket() {
        ItemGauge.set(this.currentItem, this.gauge);
        ItemPlateType.set(this.currentItem, this.plate);
        switch (this.plate) {
            case BOILER: {
                this.currentItem.func_190920_e(1);
                break;
            }
            case LARGE: {
                this.currentItem.func_190920_e(1);
                break;
            }
            case MEDIUM: {
                this.currentItem.func_190920_e(4);
                break;
            }
            case SMALL: {
                this.currentItem.func_190920_e(8);
                break;
            }
        }
        this.currentItem.func_190920_e(Math.max(1, (int)Math.floor((double)this.currentItem.func_190916_E() / this.gauge.scale())));
        this.tile.setCraftItem(this.currentItem);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == 28 || keyCode == 156) {
            this.sendPacket();
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }
}

