/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.entity.HandCar;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LocomotiveOverlay
extends Gui {
    protected Minecraft mc = Minecraft.func_71410_x();
    private int screenWidth;
    private int screenHeight;
    private int currPosX;
    private int currPosY;
    private int currSpeedPosX;
    private int bgPosX;
    private int bgPosY;
    private static final int gaugeWidth = 10;
    private static final int gaugeHeight = 50;
    private static final int gaugeSpacer = 10;
    private static final int scalarWidth = 10;
    private static final int scalarHeight = 50;
    private static final int scalarSpacer = 10;
    public static final ResourceLocation OVERLAY_STEAM_TEXTURE = new ResourceLocation("immersiverailroading:gui/overlay_steam.png");
    public static final ResourceLocation OVERLAY_DIESEL_TEXTURE = new ResourceLocation("immersiverailroading:gui/overlay_diesel.png");
    public static final ResourceLocation OVERLAY_HANDCAR_TEXTURE = new ResourceLocation("immersiverailroading:gui/overlay_handcar.png");

    public LocomotiveOverlay() {
        ScaledResolution scaled = new ScaledResolution(this.mc);
        this.screenWidth = scaled.func_78326_a();
        this.screenHeight = scaled.func_78328_b();
        this.currPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f));
        this.currSpeedPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f));
        this.bgPosX = (int)((float)this.screenWidth * ((float)ConfigGraphics.GUIPositionHorizontal / 100.0f)) - 5;
        this.currPosY = (int)((float)this.screenHeight * ((float)ConfigGraphics.GUIPositionVertical / 100.0f));
        this.currPosY -= 50;
        this.bgPosY = (int)((float)this.screenHeight * ((float)ConfigGraphics.GUIPositionVertical / 100.0f)) - 50 - 25;
    }

    public void drawGauge(int color, float liquidAmount, float tankCapacity, String units) {
        String amount = String.format("%.1f%s", Float.valueOf(liquidAmount), units);
        String capacity = String.format("%.1f%s", Float.valueOf(tankCapacity), units);
        int quantHeight = (int)(50.0f * (liquidAmount / tankCapacity));
        LocomotiveOverlay.func_73734_a((int)this.currPosX, (int)(this.currPosY + (50 - quantHeight)), (int)(this.currPosX + 10), (int)(this.currPosY + 50), (int)color);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY - 6), (double)0.0);
        double scale = 0.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.func_73732_a(this.mc.field_71466_p, amount, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY + 50 + 2), (double)0.0);
        scale = 0.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.func_73732_a(this.mc.field_71466_p, capacity, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        this.currPosX += 20;
    }

    public void drawScalar(String string, float val, float min, float max) {
        int quantHeight = 50 - (int)(45.0f * ((val - min) / (max - min))) - 5;
        LocomotiveOverlay.func_73734_a((int)this.currPosX, (int)(this.currPosY + quantHeight), (int)(this.currPosX + 10), (int)(this.currPosY + quantHeight + 5), (int)-6710887);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.currPosX + 5), (double)(this.currPosY - 6), (double)0.0);
        double scale = 0.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.func_73732_a(this.mc.field_71466_p, string, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
        this.currPosX += 20;
    }

    public void drawSpeedDisplay(Locomotive loco, int offset) {
        double speed = Math.abs(loco.getCurrentSpeed().metric());
        String text = "";
        switch (ConfigGraphics.speedUnit) {
            case mph: {
                text = String.format("%.2f mph", speed * 0.621371);
                break;
            }
            case ms: {
                text = String.format("%.2f m/s", speed / 3.6);
                break;
            }
            default: {
                text = String.format("%.2f km/h", speed);
            }
        }
        LocomotiveOverlay.func_73734_a((int)(this.currSpeedPosX + offset), (int)(this.currPosY - 10), (int)(this.currSpeedPosX + offset + 50), (int)(this.currPosY - 19), (int)-11711155);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(this.currSpeedPosX + 25 + offset), (double)(this.currPosY - 17), (double)0.0);
        double scale = 0.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.func_73732_a(this.mc.field_71466_p, text, 0, 0, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    public void drawBackground(Locomotive loco) {
        if (loco instanceof LocomotiveSteam) {
            this.mc.field_71446_o.func_110577_a(OVERLAY_STEAM_TEXTURE);
            this.func_73729_b(this.bgPosX, this.bgPosY, 0, 0, 105, 85);
        }
        if (loco instanceof LocomotiveDiesel) {
            this.mc.field_71446_o.func_110577_a(OVERLAY_DIESEL_TEXTURE);
            this.func_73729_b(this.bgPosX, this.bgPosY, 0, 0, 85, 85);
        }
        if (loco instanceof HandCar) {
            this.mc.field_71446_o.func_110577_a(OVERLAY_HANDCAR_TEXTURE);
            this.func_73729_b(this.bgPosX, this.bgPosY, 0, 0, 60, 85);
        }
    }

    public void addSpace(int space) {
        this.currPosX += space;
    }
}

