/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.ItemAugmentType;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRailAugment
extends Item {
    public static final String NAME = "item_augment";

    public ItemRailAugment() {
        this.func_77655_b("immersiverailroading:item_augment");
        this.setRegistryName(new ResourceLocation("immersiverailroading", NAME));
        this.func_77637_a(ItemTabs.MAIN_TAB);
        this.func_77625_d(16);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileRailBase te;
        if (BlockUtil.isIRRail(world, pos) && (te = TileRailBase.get((IBlockAccess)world, pos)) != null) {
            ItemStack stack = player.func_184586_b(hand);
            if (te.getAugment() == null && (player.func_184812_l_() || Gauge.from(te.getTrackGauge()) == ItemGauge.get(stack))) {
                Augment augment = ItemAugmentType.get(stack);
                TileRail parent = te.getParentTile();
                if (parent == null) {
                    return EnumActionResult.FAIL;
                }
                switch (augment) {
                    case WATER_TROUGH: {
                        return EnumActionResult.FAIL;
                    }
                    case SPEED_RETARDER: {
                        switch (parent.info.settings.type) {
                            case SWITCH: 
                            case TURN: {
                                return EnumActionResult.FAIL;
                            }
                        }
                    }
                }
                if (!world.field_72995_K) {
                    te.setAugment(augment);
                    if (!player.func_184812_l_()) {
                        stack.func_190920_e(stack.func_190916_E() - 1);
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + ItemAugmentType.get(stack).name();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Augment augment : Augment.values()) {
                if (augment == Augment.WATER_TROUGH) continue;
                ItemStack stack = new ItemStack((Item)this, 1);
                ItemAugmentType.set(stack, augment);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(GuiText.GAUGE_TOOLTIP.toString(ItemGauge.get(stack)));
    }
}

