/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.RenderComponent;
import java.util.List;
import net.minecraft.util.math.Vec3d;

public class MultiRenderComponent {
    private final Vec3d min;
    private final Vec3d max;
    public final double scale;

    public MultiRenderComponent(List<RenderComponent> subComponents) {
        double minX = subComponents.get((int)0).min.field_72450_a;
        double minY = subComponents.get((int)0).min.field_72448_b;
        double minZ = subComponents.get((int)0).min.field_72449_c;
        double maxX = subComponents.get((int)0).max.field_72450_a;
        double maxY = subComponents.get((int)0).max.field_72448_b;
        double maxZ = subComponents.get((int)0).max.field_72449_c;
        for (RenderComponent rc : subComponents) {
            minX = Math.min(minX, rc.min.field_72450_a);
            minY = Math.min(minY, rc.min.field_72448_b);
            minZ = Math.min(minZ, rc.min.field_72449_c);
            maxX = Math.max(maxX, rc.max.field_72450_a);
            maxY = Math.max(maxY, rc.max.field_72448_b);
            maxZ = Math.max(maxZ, rc.max.field_72449_c);
        }
        this.min = new Vec3d(minX, minY, minZ);
        this.max = new Vec3d(maxX, maxY, maxZ);
        this.scale = subComponents.get((int)0).scale;
    }

    private MultiRenderComponent(Vec3d min, Vec3d max, double scale) {
        this.min = min;
        this.max = max;
        this.scale = scale;
    }

    public MultiRenderComponent scale(Gauge gauge) {
        return new MultiRenderComponent(this.min, this.max, gauge.scale());
    }

    public Vec3d center() {
        Vec3d min = this.min.func_186678_a(this.scale);
        Vec3d max = this.max.func_186678_a(this.scale);
        return new Vec3d((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
    }

    public double height() {
        Vec3d min = this.min.func_186678_a(this.scale);
        Vec3d max = this.max.func_186678_a(this.scale);
        return max.field_72448_b - min.field_72448_b;
    }
}

