/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.obj;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.util.RelativeResource;
import cam72cam.immersiverailroading.util.VecUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.ArrayUtils;

public class OBJModel {
    public Map<String, int[]> groups = new LinkedHashMap<String, int[]>();
    public float[] vertices;
    public float[] vertexNormals;
    public float[] vertexTextures;
    public int[] faceVerts;
    public String[] faceMTLs;
    public byte[] offsetU;
    public byte[] offsetV;
    public Map<String, Material> materials = new HashMap<String, Material>();
    public float darken;
    private Map<String, Vec3d> mins = new HashMap<String, Vec3d>();
    private Map<String, Vec3d> maxs = new HashMap<String, Vec3d>();

    public OBJModel(ResourceLocation modelLoc, float darken) throws Exception {
        this(modelLoc, darken, 1.0);
    }

    public OBJModel(ResourceLocation modelLoc, float darken, double scale) throws Exception {
        Vec3d v;
        String line;
        InputStream input = ImmersiveRailroading.proxy.getResourceStream(modelLoc);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        this.darken = darken;
        String currentGroupName = "defaultName";
        ArrayList<Integer> currentGroup = new ArrayList<Integer>();
        ArrayList<String> materialPaths = new ArrayList<String>();
        String currentMaterial = null;
        ArrayList faceVerts = new ArrayList();
        ArrayList<String> faceMTLs = new ArrayList<String>();
        ArrayList<Float> vertices = new ArrayList<Float>();
        ArrayList<Float> vertexNormals = new ArrayList<Float>();
        ArrayList<Float> vertexTextures = new ArrayList<Float>();
        Consumer<String[]> addFace = args -> {
            for (int i = 0; i < ((String[])args).length; ++i) {
                for (int j : OBJModel.parsePoint(args[i])) {
                    faceVerts.add(j);
                }
            }
        };
        block47: while ((line = reader.readLine()) != null) {
            String cmd;
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] args2 = line.split(" ");
            switch (cmd = args2[0]) {
                case "mtllib": {
                    materialPaths.add(args2[1]);
                    break;
                }
                case "usemtl": {
                    currentMaterial = args2[1].intern();
                    break;
                }
                case "o": 
                case "g": {
                    if (currentGroup.size() > 0) {
                        this.groups.put(currentGroupName, ArrayUtils.toPrimitive((Integer[])currentGroup.toArray(new Integer[0])));
                    }
                    currentGroupName = args2[1].intern();
                    currentGroup = new ArrayList();
                    break;
                }
                case "v": {
                    vertices.add(Float.valueOf(Float.parseFloat(args2[1]) * (float)scale));
                    vertices.add(Float.valueOf(Float.parseFloat(args2[2]) * (float)scale));
                    vertices.add(Float.valueOf(Float.parseFloat(args2[3]) * (float)scale));
                    break;
                }
                case "vn": {
                    vertexNormals.add(Float.valueOf(Float.parseFloat(args2[1])));
                    vertexNormals.add(Float.valueOf(Float.parseFloat(args2[2])));
                    vertexNormals.add(Float.valueOf(Float.parseFloat(args2[3])));
                    break;
                }
                case "vt": {
                    vertexTextures.add(Float.valueOf(Float.parseFloat(args2[1])));
                    vertexTextures.add(Float.valueOf(Float.parseFloat(args2[2])));
                    break;
                }
                case "f": {
                    int idx;
                    if (args2.length == 4) {
                        addFace.accept(new String[]{args2[1], args2[2], args2[3]});
                        idx = faceMTLs.size();
                        faceMTLs.add(currentMaterial);
                        currentGroup.add(idx);
                        break;
                    }
                    if (args2.length == 5) {
                        addFace.accept(new String[]{args2[1], args2[2], args2[3]});
                        idx = faceMTLs.size();
                        faceMTLs.add(currentMaterial);
                        currentGroup.add(idx);
                        addFace.accept(new String[]{args2[3], args2[4], args2[1]});
                        idx = faceMTLs.size();
                        faceMTLs.add(currentMaterial);
                        currentGroup.add(idx);
                        break;
                    }
                    for (int i = 2; i < args2.length - 1; ++i) {
                        addFace.accept(new String[]{args2[1], args2[i], args2[i + 1]});
                        idx = faceMTLs.size();
                        faceMTLs.add(currentMaterial);
                        currentGroup.add(idx);
                    }
                    continue block47;
                }
                case "s": {
                    break;
                }
                case "l": {
                    break;
                }
                default: {
                    ImmersiveRailroading.debug("OBJ: ignored line '" + line + "'", new Object[0]);
                }
            }
        }
        if (currentGroup.size() > 0) {
            this.groups.put(currentGroupName, ArrayUtils.toPrimitive((Integer[])currentGroup.toArray(new Integer[0])));
        }
        reader.close();
        this.vertices = ArrayUtils.toPrimitive((Float[])vertices.toArray(new Float[0]));
        this.vertexNormals = ArrayUtils.toPrimitive((Float[])vertexNormals.toArray(new Float[0]));
        this.vertexTextures = ArrayUtils.toPrimitive((Float[])vertexTextures.toArray(new Float[0]));
        this.faceVerts = ArrayUtils.toPrimitive((Integer[])faceVerts.toArray(new Integer[0]));
        this.faceMTLs = faceMTLs.toArray(new String[0]);
        if (materialPaths.size() == 0) {
            return;
        }
        for (String materialPath : materialPaths) {
            Material currentMTL = null;
            input = ImmersiveRailroading.proxy.getResourceStream(RelativeResource.getRelative(modelLoc, materialPath));
            reader = new BufferedReader(new InputStreamReader(input));
            block50: while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                String[] parts = line.split(" ");
                switch (parts[0]) {
                    case "newmtl": {
                        if (currentMTL != null) {
                            this.materials.put(currentMTL.name, currentMTL);
                        }
                        currentMTL = new Material();
                        currentMTL.name = parts[1];
                        continue block50;
                    }
                    case "Ka": {
                        currentMTL.Ka = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Ka.put(Float.parseFloat(parts[1]));
                        currentMTL.Ka.put(Float.parseFloat(parts[2]));
                        currentMTL.Ka.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Ka.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Ka.put(1.0f);
                        }
                        currentMTL.Ka.position(0);
                        continue block50;
                    }
                    case "Kd": {
                        currentMTL.Kd = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Kd.put(Float.parseFloat(parts[1]));
                        currentMTL.Kd.put(Float.parseFloat(parts[2]));
                        currentMTL.Kd.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Kd.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Kd.put(1.0f);
                        }
                        currentMTL.Kd.position(0);
                        continue block50;
                    }
                    case "Ks": {
                        currentMTL.Ks = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Ks.put(Float.parseFloat(parts[1]));
                        currentMTL.Ks.put(Float.parseFloat(parts[2]));
                        currentMTL.Ks.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Ks.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Ks.put(1.0f);
                        }
                        currentMTL.Ks.position(0);
                        continue block50;
                    }
                    case "map_Kd": {
                        currentMTL.texKd = RelativeResource.getRelative(modelLoc, parts[1]);
                        continue block50;
                    }
                    case "Ns": {
                        continue block50;
                    }
                    case "Ke": {
                        continue block50;
                    }
                    case "Ni": {
                        continue block50;
                    }
                    case "d": {
                        continue block50;
                    }
                    case "illum": {
                        continue block50;
                    }
                }
                ImmersiveRailroading.debug("MTL: ignored line '" + line + "'", new Object[0]);
            }
            if (currentMTL != null) {
                this.materials.put(currentMTL.name, currentMTL);
            }
            reader.close();
        }
        for (String group : this.groups()) {
            int[] faces;
            Vec3d min = null;
            for (int face : faces = this.groups.get(group)) {
                for (int[] point : this.points(face)) {
                    v = this.vertices(point[0]);
                    min = min == null ? v : VecUtil.min(min, v);
                }
            }
            this.mins.put(group, min);
        }
        for (String group : this.groups()) {
            int[] faces;
            Vec3d max = null;
            for (int face : faces = this.groups.get(group)) {
                for (int[] point : this.points(face)) {
                    v = this.vertices(point[0]);
                    max = max == null ? v : VecUtil.max(max, v);
                }
            }
            this.maxs.put(group, max);
        }
    }

    private static int[] parsePoint(String point) {
        String[] sp = point.split("/");
        int[] ret = new int[]{-1, -1, -1};
        for (int i = 0; i < sp.length; ++i) {
            if (sp[i].equals("")) continue;
            ret[i] = Integer.parseInt(sp[i]) - 1;
        }
        return ret;
    }

    public Set<String> groups() {
        return this.groups.keySet();
    }

    public Vec3d minOfGroup(Iterable<String> groupNames) {
        Vec3d min = null;
        for (String group : groupNames) {
            Vec3d gmin = this.mins.get(group);
            if (min == null) {
                min = gmin;
                continue;
            }
            min = VecUtil.min(min, gmin);
        }
        return min;
    }

    public Vec3d maxOfGroup(Iterable<String> groupNames) {
        Vec3d max = null;
        for (String group : groupNames) {
            Vec3d gmax = this.maxs.get(group);
            if (max == null) {
                max = gmax;
                continue;
            }
            max = VecUtil.max(max, gmax);
        }
        return max;
    }

    public Vec3d centerOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return new Vec3d((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
    }

    public double heightOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72448_b - min.field_72448_b;
    }

    public double lengthOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72450_a - min.field_72450_a;
    }

    public double widthOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72449_c - min.field_72449_c;
    }

    public Vec3d vertices(int i) {
        return new Vec3d((double)this.vertices[i * 3 + 0], (double)this.vertices[i * 3 + 1], (double)this.vertices[i * 3 + 2]);
    }

    public Vec3d vertexNormals(int i) {
        return new Vec3d((double)this.vertexNormals[i * 3 + 0], (double)this.vertexNormals[i * 3 + 1], (double)this.vertexNormals[i * 3 + 2]);
    }

    public Vec2f vertexTextures(int i) {
        return new Vec2f(this.vertexTextures[i * 2 + 0], this.vertexTextures[i * 2 + 1]);
    }

    public int[][] points(int pointStart) {
        int[][] points = new int[3][];
        for (int i = 0; i < 3; ++i) {
            points[i] = new int[]{this.faceVerts[pointStart * 9 + i * 3 + 0], this.faceVerts[pointStart * 9 + i * 3 + 1], this.faceVerts[pointStart * 9 + i * 3 + 2]};
        }
        return points;
    }
}

