/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.OreHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class Multiblock {
    private final MultiblockComponent[][][] components;
    private final String name;
    protected final List<BlockPos> componentPositions;
    protected static final MultiblockComponent AIR = new MultiblockComponent();

    protected static final MultiblockComponent STEEL() {
        return new MultiblockComponent(OreHelper.IR_STEEL_BLOCK);
    }

    protected static final MultiblockComponent CASING() {
        return new MultiblockComponent(OreHelper.IR_CASTING_CASING);
    }

    protected static final MultiblockComponent L_ENG() {
        return new MultiblockComponent(OreHelper.IR_LIGHT_ENG);
    }

    protected static final MultiblockComponent H_ENG() {
        return new MultiblockComponent(OreHelper.IR_HEAVY_ENG);
    }

    protected static final MultiblockComponent S_SCAF() {
        return new MultiblockComponent(OreHelper.IR_SCAFFOLDING);
    }

    protected Multiblock(String name, MultiblockComponent[][][] components) {
        this.name = name;
        this.components = components;
        this.componentPositions = new ArrayList<BlockPos>();
        for (int z = 0; z < components.length; ++z) {
            MultiblockComponent[][] zcomp = components[z];
            for (int y = 0; y < components[z].length; ++y) {
                MultiblockComponent[] ycomp = zcomp[y];
                for (int x = 0; x < ycomp.length; ++x) {
                    this.componentPositions.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    protected MultiblockComponent lookup(BlockPos offset) {
        return this.components[offset.func_177952_p()][offset.func_177956_o()][offset.func_177958_n()];
    }

    private boolean checkValid(IBlockAccess world, BlockPos origin, BlockPos offset, Rotation rot) {
        BlockPos pos = origin.func_177971_a((Vec3i)offset.func_190942_a(rot));
        MultiblockComponent component = this.lookup(offset);
        return component.valid(world, pos);
    }

    public boolean tryCreate(World world, BlockPos pos) {
        for (BlockPos activationLocation : this.componentPositions) {
            for (Rotation rot : Rotation.values()) {
                BlockPos origin = pos.func_177973_b((Vec3i)activationLocation.func_190942_a(rot));
                boolean valid = true;
                for (BlockPos offset : this.componentPositions) {
                    valid = valid && this.checkValid((IBlockAccess)world, origin, offset, rot);
                }
                if (!valid) continue;
                if (!world.field_72995_K) {
                    this.instance(world, origin, rot).onCreate();
                }
                return true;
            }
        }
        return false;
    }

    public abstract BlockPos placementPos();

    public void place(World world, EntityPlayer player, BlockPos pos, Rotation rot) {
        BlockPos compPos;
        MultiblockComponent component;
        HashMap<String, Integer> missing = new HashMap<String, Integer>();
        BlockPos origin = pos.func_177973_b((Vec3i)this.placementPos().func_190942_a(rot));
        for (BlockPos offset : this.componentPositions) {
            component = this.lookup(offset);
            if (component.valid((IBlockAccess)world, compPos = origin.func_177971_a((Vec3i)offset.func_190942_a(rot))) || world.func_175623_d(compPos)) continue;
            if (BlockUtil.canBeReplaced(world, compPos, false)) {
                world.func_175655_b(compPos, true);
                continue;
            }
            player.func_145747_a((ITextComponent)ChatText.INVALID_BLOCK.getMessage(compPos.func_177958_n(), compPos.func_177956_o(), compPos.func_177952_p()));
            return;
        }
        for (BlockPos offset : this.componentPositions) {
            component = this.lookup(offset);
            if (component.valid((IBlockAccess)world, compPos = origin.func_177971_a((Vec3i)offset.func_190942_a(rot))) || component.place(world, player, compPos)) continue;
            if (!missing.containsKey(component.name)) {
                missing.put(component.name, 0);
            }
            missing.put(component.name, (Integer)missing.get(component.name) + 1);
        }
        if (missing.size() != 0) {
            player.func_145747_a((ITextComponent)ChatText.STOCK_MISSING.getMessage(new Object[0]));
            for (String name : missing.keySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("  - %d x %s", missing.get(name), name)));
            }
        }
    }

    public Map<BlockPos, IBlockState> blueprint() {
        HashMap<BlockPos, IBlockState> result = new HashMap<BlockPos, IBlockState>();
        for (BlockPos offset : this.componentPositions) {
            MultiblockComponent component = this.lookup(offset);
            result.put(offset, component.def);
        }
        return result;
    }

    public MultiblockInstance instance(World world, BlockPos origin, Rotation rot) {
        return this.newInstance(world, origin, rot);
    }

    protected abstract MultiblockInstance newInstance(World var1, BlockPos var2, Rotation var3);

    public abstract class MultiblockInstance {
        protected final World world;
        protected final BlockPos origin;
        protected final Rotation rot;

        public MultiblockInstance(World world, BlockPos origin, Rotation rot) {
            this.world = world;
            this.origin = origin;
            this.rot = rot;
        }

        public void onCreate() {
            for (BlockPos offset : Multiblock.this.componentPositions) {
                MultiblockComponent comp = Multiblock.this.lookup(offset);
                if (comp == AIR) continue;
                BlockPos pos = this.getPos(offset);
                IBlockState origState = this.world.func_180495_p(pos);
                this.world.func_175656_a(pos, IRBlocks.BLOCK_MULTIBLOCK.func_176223_P());
                TileMultiblock te = TileMultiblock.get((IBlockAccess)this.world, pos);
                te.configure(Multiblock.this.name, this.rot, offset, origState);
            }
        }

        public abstract boolean onBlockActivated(EntityPlayer var1, EnumHand var2, BlockPos var3);

        public abstract int getInvSize(BlockPos var1);

        public abstract boolean isRender(BlockPos var1);

        public abstract void tick(BlockPos var1);

        public abstract boolean canInsertItem(BlockPos var1, int var2, ItemStack var3);

        public abstract boolean isOutputSlot(BlockPos var1, int var2);

        public abstract int getSlotLimit(BlockPos var1, int var2);

        public abstract boolean canRecievePower(BlockPos var1);

        public void onBreak() {
            for (BlockPos offset : Multiblock.this.componentPositions) {
                MultiblockComponent comp = Multiblock.this.lookup(offset);
                if (comp == AIR) continue;
                BlockPos pos = this.getPos(offset);
                TileMultiblock te = TileMultiblock.get((IBlockAccess)this.world, pos);
                if (te == null) {
                    this.world.func_175655_b(pos, true);
                    continue;
                }
                te.onBreak();
            }
        }

        protected BlockPos getPos(BlockPos offset) {
            return this.origin.func_177971_a((Vec3i)offset.func_190942_a(this.rot));
        }

        protected TileMultiblock getTile(BlockPos offset) {
            TileMultiblock te = TileMultiblock.get((IBlockAccess)this.world, this.getPos(offset));
            if (te == null) {
                if (!this.world.field_72995_K) {
                    ImmersiveRailroading.warn("Multiblock TE is null: %s %s %s %s", this.getPos(offset), offset, this.world.field_72995_K, this.getClass());
                }
                return null;
            }
            if (!te.isLoaded()) {
                if (!this.world.field_72995_K) {
                    ImmersiveRailroading.info("Multiblock is still loading: %s %s %s %s", this.getPos(offset), offset, this.world.field_72995_K, this.getClass());
                }
                return null;
            }
            return te;
        }
    }
}

