/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.nbt.ItemRawCast;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class SteamHammerMultiblock
extends Multiblock {
    private static MultiblockComponent piston = new MultiblockComponent((Block)Blocks.field_150331_J);
    public static final String NAME = "STEAM_HAMMER";
    private static final BlockPos center = new BlockPos(2, 0, 0);
    private static final BlockPos power = new BlockPos(2, 5, 0);

    public SteamHammerMultiblock() {
        super(NAME, new MultiblockComponent[][][]{{{SteamHammerMultiblock.L_ENG(), AIR, SteamHammerMultiblock.STEEL(), AIR, SteamHammerMultiblock.L_ENG()}, {SteamHammerMultiblock.L_ENG(), AIR, AIR, AIR, SteamHammerMultiblock.L_ENG()}, {SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.H_ENG(), SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.L_ENG()}, {AIR, SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.H_ENG(), SteamHammerMultiblock.L_ENG(), AIR}, {AIR, AIR, piston, AIR, AIR}, {AIR, AIR, SteamHammerMultiblock.H_ENG(), AIR, AIR}}});
    }

    @Override
    public BlockPos placementPos() {
        return new BlockPos(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, BlockPos origin, Rotation rot) {
        return new SteamHammerInstance(world, origin, rot);
    }

    public class SteamHammerInstance
    extends Multiblock.MultiblockInstance {
        public SteamHammerInstance(World world, BlockPos origin, Rotation rot) {
            super(SteamHammerMultiblock.this, world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(EntityPlayer player, EnumHand hand, BlockPos offset) {
            if (this.isCenter(offset)) {
                if (!this.world.field_72995_K) {
                    BlockPos pos = this.getPos(offset);
                    player.openGui((Object)ImmersiveRailroading.instance, GuiTypes.STEAM_HAMMER.ordinal(), this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            return false;
        }

        private boolean isCenter(BlockPos offset) {
            return offset.equals((Object)center);
        }

        @Override
        public boolean isRender(BlockPos offset) {
            return this.isCenter(offset);
        }

        @Override
        public int getInvSize(BlockPos offset) {
            return this.isCenter(offset) ? 2 : 0;
        }

        @Override
        public void tick(BlockPos offset) {
            if (!this.isCenter(offset)) {
                return;
            }
            TileMultiblock te = this.getTile(offset);
            if (te == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.field_72995_K) {
                if (te.getRenderTicks() % 10L == 0L && te.getCraftProgress() != 0) {
                    this.world.func_184134_a((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 0.2f, false);
                }
                return;
            }
            if (te.getCraftProgress() != 0) {
                IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
                energy.extractEnergy(32, false);
                te.setCraftProgress(Math.max(0, te.getCraftProgress() - 1));
            }
            float progress = te.getCraftProgress();
            ItemStackHandler container = te.getContainer();
            ItemStack input = container.getStackInSlot(0);
            ItemStack output = container.getStackInSlot(1);
            if (progress == 0.0f && !input.func_190926_b() && ItemRawCast.get(input) && output.func_190926_b()) {
                te.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = input.func_77946_l();
                out.func_190920_e(1);
                ItemRawCast.set(out, false);
                container.setStackInSlot(1, out);
                input.func_190918_g(1);
                container.setStackInSlot(0, input);
                progress = 100.0f;
            }
        }

        @Override
        public boolean canInsertItem(BlockPos offset, int slot, ItemStack stack) {
            return slot == 0 && ItemRawCast.get(stack);
        }

        @Override
        public boolean isOutputSlot(BlockPos offset, int slot) {
            return slot == 1;
        }

        @Override
        public int getSlotLimit(BlockPos offset, int slot) {
            return this.isCenter(offset) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(BlockPos offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
            return energy.getEnergyStored() > 32;
        }
    }
}

