/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BuildableStockSyncPacket
implements IMessage {
    private int dimension;
    private int entityID;
    private List<ItemComponentType> items;

    public BuildableStockSyncPacket() {
    }

    public BuildableStockSyncPacket(EntityBuildableRollingStock stock) {
        this.dimension = stock.field_71093_bK;
        this.entityID = stock.func_145782_y();
        this.items = stock.getItemComponents();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.entityID);
        BufferUtil.writeItemComponentTypes(buf, this.items);
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.entityID = buf.readInt();
        this.items = BufferUtil.readItemComponentTypes(buf);
    }

    public static class Handler
    implements IMessageHandler<BuildableStockSyncPacket, IMessage> {
        public IMessage onMessage(BuildableStockSyncPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(BuildableStockSyncPacket message, MessageContext ctx) {
            EntityBuildableRollingStock entity = (EntityBuildableRollingStock)ImmersiveRailroading.proxy.getWorld(message.dimension).func_73045_a(message.entityID);
            if (entity == null) {
                return;
            }
            entity.setComponents(message.items);
        }
    }
}

