/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRailUpdatePacket
implements IMessage {
    private int slot;
    private BlockPos tilePreviewPos;
    private RailSettings settings;

    public ItemRailUpdatePacket() {
    }

    @SideOnly(value=Side.CLIENT)
    public ItemRailUpdatePacket(int slot, RailSettings settings) {
        this.slot = slot;
        this.settings = settings;
    }

    public ItemRailUpdatePacket(BlockPos tilePreviewPos, RailSettings settings) {
        this.tilePreviewPos = tilePreviewPos;
        this.settings = settings;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.slot = buf.readInt();
        } else {
            this.tilePreviewPos = BlockPos.func_177969_a((long)buf.readLong());
        }
        this.settings = new RailSettings(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.tilePreviewPos == null);
        if (this.tilePreviewPos == null) {
            buf.writeInt(this.slot);
        } else {
            buf.writeLong(this.tilePreviewPos.func_177986_g());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.settings.toNBT());
    }

    public static class Handler
    implements IMessageHandler<ItemRailUpdatePacket, IMessage> {
        public IMessage onMessage(ItemRailUpdatePacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(ItemRailUpdatePacket message, MessageContext ctx) {
            ItemStack stack;
            TileRailPreview te = null;
            if (message.tilePreviewPos == null) {
                stack = ctx.getServerHandler().field_147369_b.field_71071_by.func_70301_a(message.slot);
            } else {
                te = TileRailPreview.get((IBlockAccess)ctx.getServerHandler().field_147369_b.field_70170_p, message.tilePreviewPos);
                if (te == null) {
                    ImmersiveRailroading.warn("Got invalid item rail update packet at %s", message.tilePreviewPos);
                    return;
                }
                stack = te.getItem();
            }
            ItemTrackBlueprint.settings(stack, message.settings);
            if (message.tilePreviewPos == null) {
                ctx.getServerHandler().field_147369_b.field_71071_by.func_70299_a(message.slot, stack);
            } else {
                te.setItem(stack);
            }
        }
    }
}

