/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.net;

import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.library.KeyTypes;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KeyPressPacket
implements IMessage {
    private int dimension;
    private int keyBindingOrdinal;
    private int sourceEntityID;
    private int targetEntityID;
    private boolean sprinting;

    public KeyPressPacket() {
    }

    @SideOnly(value=Side.CLIENT)
    public KeyPressPacket(KeyTypes binding, int dimension, int sourceEntityID, int targetEntityID, boolean sprinting) {
        this.dimension = dimension;
        this.keyBindingOrdinal = binding.ordinal();
        this.sourceEntityID = sourceEntityID;
        this.targetEntityID = targetEntityID;
        this.sprinting = sprinting;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.keyBindingOrdinal = buf.readInt();
        this.sourceEntityID = buf.readInt();
        this.targetEntityID = buf.readInt();
        this.sprinting = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.keyBindingOrdinal);
        buf.writeInt(this.sourceEntityID);
        buf.writeInt(this.targetEntityID);
        buf.writeBoolean(this.sprinting);
    }

    public static class Handler
    implements IMessageHandler<KeyPressPacket, IMessage> {
        public IMessage onMessage(KeyPressPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(final KeyPressPacket message, MessageContext ctx) {
            Entity source = ctx.getServerHandler().field_147369_b.func_71121_q().func_73045_a(message.sourceEntityID);
            List matches = ctx.getServerHandler().field_147369_b.func_71121_q().func_175644_a(EntityRidableRollingStock.class, (Predicate)new Predicate<EntityRidableRollingStock>(){

                public boolean apply(@Nullable EntityRidableRollingStock entity) {
                    return entity != null && entity.func_145782_y() == message.targetEntityID;
                }
            });
            if (matches.isEmpty()) {
                return;
            }
            ((EntityRidableRollingStock)((Object)matches.get(0))).handleKeyPress(source, KeyTypes.values()[message.keyBindingOrdinal], message.sprinting);
        }
    }
}

