/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.util.BufferUtil;
import cam72cam.immersiverailroading.util.Speed;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;

public class TickPos {
    public int tickID;
    public Speed speed;
    public boolean isOffTrack;
    public Vec3d position;
    public float frontYaw;
    public float rearYaw;
    public float rotationYaw;
    public float rotationPitch;

    public TickPos() {
    }

    public TickPos(int tickPosID, Speed speed, Vec3d position, float frontYaw, float rearYaw, float rotationYaw, float rotationPitch, boolean isOffTrack) {
        this.tickID = tickPosID;
        this.speed = speed;
        this.isOffTrack = isOffTrack;
        this.position = position;
        this.frontYaw = frontYaw;
        this.rearYaw = rearYaw;
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
    }

    public TickPos clone() {
        return new TickPos(this.tickID, this.speed, this.position, this.frontYaw, this.rearYaw, this.rotationYaw, this.rotationPitch, this.isOffTrack);
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.tickID);
        buf.writeFloat((float)this.speed.metric());
        buf.writeBoolean(this.isOffTrack);
        BufferUtil.writeVec3d(buf, this.position);
        buf.writeFloat(this.frontYaw);
        buf.writeFloat(this.rearYaw);
        buf.writeFloat(this.rotationYaw);
        buf.writeFloat(this.rotationPitch);
    }

    public void read(ByteBuf buf) {
        this.tickID = buf.readInt();
        this.speed = Speed.fromMetric(buf.readFloat());
        this.isOffTrack = buf.readBoolean();
        this.position = BufferUtil.readVec3d(buf);
        this.frontYaw = buf.readFloat();
        this.rearYaw = buf.readFloat();
        this.rotationYaw = buf.readFloat();
        this.rotationPitch = buf.readFloat();
    }
}

