/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.proxy;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.EntitySmokeParticle;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.gui.CastingGUI;
import cam72cam.immersiverailroading.gui.FreightContainer;
import cam72cam.immersiverailroading.gui.FreightContainerGui;
import cam72cam.immersiverailroading.gui.PlateRollerGUI;
import cam72cam.immersiverailroading.gui.SteamHammerContainer;
import cam72cam.immersiverailroading.gui.SteamHammerContainerGui;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainer;
import cam72cam.immersiverailroading.gui.SteamLocomotiveContainerGui;
import cam72cam.immersiverailroading.gui.TankContainer;
import cam72cam.immersiverailroading.gui.TankContainerGui;
import cam72cam.immersiverailroading.gui.TenderContainer;
import cam72cam.immersiverailroading.gui.TenderContainerGui;
import cam72cam.immersiverailroading.gui.TrackGui;
import cam72cam.immersiverailroading.gui.overlay.DieselLocomotiveOverlay;
import cam72cam.immersiverailroading.gui.overlay.HandCarOverlay;
import cam72cam.immersiverailroading.gui.overlay.SteamLocomotiveOverlay;
import cam72cam.immersiverailroading.items.nbt.ItemMultiblockType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.net.KeyPressPacket;
import cam72cam.immersiverailroading.net.MousePressPacket;
import cam72cam.immersiverailroading.proxy.ClientResourceReloadListener;
import cam72cam.immersiverailroading.proxy.CommonProxy;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.OBJTextureSheet;
import cam72cam.immersiverailroading.render.RenderCacheTimeLimiter;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.render.block.RailBaseModel;
import cam72cam.immersiverailroading.render.entity.MagicEntity;
import cam72cam.immersiverailroading.render.entity.MagicEntityRender;
import cam72cam.immersiverailroading.render.entity.ParticleRender;
import cam72cam.immersiverailroading.render.entity.RenderOverride;
import cam72cam.immersiverailroading.render.entity.StockEntityRender;
import cam72cam.immersiverailroading.render.entity.StockModel;
import cam72cam.immersiverailroading.render.item.PlateItemModel;
import cam72cam.immersiverailroading.render.item.RailAugmentItemModel;
import cam72cam.immersiverailroading.render.item.RailCastItemRender;
import cam72cam.immersiverailroading.render.item.RailItemRender;
import cam72cam.immersiverailroading.render.item.StockItemComponentModel;
import cam72cam.immersiverailroading.render.item.StockItemModel;
import cam72cam.immersiverailroading.render.item.TrackBlueprintItemModel;
import cam72cam.immersiverailroading.render.multiblock.MBBlueprintRender;
import cam72cam.immersiverailroading.render.rail.RailRenderUtil;
import cam72cam.immersiverailroading.render.tile.TileMultiblockRender;
import cam72cam.immersiverailroading.render.tile.TileRailPreviewRender;
import cam72cam.immersiverailroading.render.tile.TileRailRender;
import cam72cam.immersiverailroading.sound.IRSoundManager;
import cam72cam.immersiverailroading.sound.ISound;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.GLBoolTracker;
import cam72cam.immersiverailroading.util.GPUInfo;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import paulscode.sound.SoundSystemConfig;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static Map<KeyTypes, KeyBinding> keys = new HashMap<KeyTypes, KeyBinding>();
    private static Map<Integer, ExpireableList<BlockPos, TileRailPreview>> previews = new HashMap<Integer, ExpireableList<BlockPos, TileRailPreview>>();
    private static ExpireableList<String, RailInfo> infoCache = new ExpireableList();
    private static IRSoundManager manager;
    public static MagicEntity magical;
    public static RenderCacheTimeLimiter renderCacheLimiter;
    private static String missingResources;
    private static float dampeningAmount;
    public static final IRenderFactory<EntityRollingStock> RENDER_INSTANCE;
    public static final IRenderFactory<EntitySmokeParticle> PARTICLE_RENDER;
    public static final IRenderFactory<MagicEntity> MAGIC_RENDER;
    private static final Map<String, BufferedImage> cachedIcons;
    private static int sndCacheId;
    private static List<ISound> sndCache;
    private static int tickCount;

    public static float getDampeningAmount() {
        return dampeningAmount;
    }

    public static void dampenSound() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        dampeningAmount = 1.0f;
        if (player != null && player.func_184218_aH() && player.func_184187_bx() instanceof EntityRidableRollingStock) {
            EntityRidableRollingStock ridableStock = (EntityRidableRollingStock)player.func_184187_bx();
            dampeningAmount = ridableStock.getDefinition().dampeningAmount;
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int entityIDorPosX, int posY, int posZ) {
        switch (GuiTypes.values()[ID]) {
            case FREIGHT: {
                return new FreightContainerGui((CarFreight)world.func_73045_a(entityIDorPosX), new FreightContainer((IInventory)player.field_71071_by, (CarFreight)world.func_73045_a(entityIDorPosX)));
            }
            case TANK: 
            case DIESEL_LOCOMOTIVE: {
                return new TankContainerGui((FreightTank)world.func_73045_a(entityIDorPosX), new TankContainer((IInventory)player.field_71071_by, (FreightTank)world.func_73045_a(entityIDorPosX)));
            }
            case TENDER: {
                return new TenderContainerGui((Tender)world.func_73045_a(entityIDorPosX), new TenderContainer((IInventory)player.field_71071_by, (Tender)world.func_73045_a(entityIDorPosX)));
            }
            case STEAM_LOCOMOTIVE: {
                return new SteamLocomotiveContainerGui((LocomotiveSteam)world.func_73045_a(entityIDorPosX), new SteamLocomotiveContainer((IInventory)player.field_71071_by, (LocomotiveSteam)world.func_73045_a(entityIDorPosX)));
            }
            case RAIL: {
                return new TrackGui();
            }
            case RAIL_PREVIEW: {
                return new TrackGui(world, entityIDorPosX, posY, posZ);
            }
            case STEAM_HAMMER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new SteamHammerContainerGui(new SteamHammerContainer((IInventory)player.field_71071_by, te));
            }
            case PLATE_ROLLER: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new PlateRollerGUI(te);
            }
            case CASTING: {
                TileMultiblock te = TileMultiblock.get((IBlockAccess)world, new BlockPos(entityIDorPosX, posY, posZ));
                if (te == null || !te.isLoaded()) {
                    return null;
                }
                return new CastingGUI(te);
            }
        }
        return null;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        super.preInit(event);
        if (ConfigSound.overrideSoundChannels) {
            SoundSystemConfig.setNumberNormalChannels((int)Math.max(SoundSystemConfig.getNumberNormalChannels(), 300));
        }
        if (Loader.isModLoaded((String)"igwmod")) {
            FMLInterModComms.sendMessage((String)"igwmod", (String)"cam72cam.immersiverailroading.thirdparty.IGWMod", (String)"init");
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        keys.put(KeyTypes.THROTTLE_UP, new KeyBinding("ir_keys.increase_throttle", 72, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.THROTTLE_ZERO, new KeyBinding("ir_keys.zero_throttle", 76, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.THROTTLE_DOWN, new KeyBinding("ir_keys.decrease_throttle", 80, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_UP, new KeyBinding("ir_keys.increase_brake", 71, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_ZERO, new KeyBinding("ir_keys.zero_brake", 75, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.AIR_BRAKE_DOWN, new KeyBinding("ir_keys.decrease_brake", 79, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.HORN, new KeyBinding("ir_keys.horn", 156, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.DEAD_MANS_SWITCH, new KeyBinding("ir_keys.dead_mans_switch", 141, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.START_STOP_ENGINE, new KeyBinding("ir_keys.start_stop_engine", 78, "key.categories.immersiverailroading"));
        keys.put(KeyTypes.BELL, new KeyBinding("ir_keys.bell", 74, "key.categories.immersiverailroading"));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_UP));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_DOWN));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.THROTTLE_ZERO));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_UP));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_DOWN));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.AIR_BRAKE_ZERO));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.HORN));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.BELL));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.DEAD_MANS_SWITCH));
        ClientRegistry.registerKeyBinding((KeyBinding)keys.get((Object)KeyTypes.START_STOP_ENGINE));
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new ClientResourceReloadListener());
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{IRBlocks.BLOCK_RAIL, IRBlocks.BLOCK_RAIL_GAG});
    }

    @Override
    public World getWorld(int dimension) {
        return FMLClientHandler.instance().getWorldClient();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        for (Class type : entityClasses) {
            RenderingRegistry.registerEntityRenderingHandler((Class)type, RENDER_INSTANCE);
        }
        RenderingRegistry.registerEntityRenderingHandler(EntitySmokeParticle.class, PARTICLE_RENDER);
        RenderingRegistry.registerEntityRenderingHandler(MagicEntity.class, MAGIC_RENDER);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        OBJLoader.INSTANCE.addDomain("immersiverailroading".toLowerCase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRail.class, (TileEntitySpecialRenderer)new TileRailRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRailPreview.class, (TileEntitySpecialRenderer)new TileRailPreviewRender());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMultiblock.class, (TileEntitySpecialRenderer)new TileMultiblockRender());
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_LARGE_WRENCH, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_LARGE_WRENCH.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_HOOK, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_HOOK.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_CONDUCTOR_WHISTLE, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_CONDUCTOR_WHISTLE.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_TRACK_BLUEPRINT, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_TRACK_BLUEPRINT.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_ROLLING_STOCK_COMPONENT, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_ROLLING_STOCK_COMPONENT.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_ROLLING_STOCK, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_ROLLING_STOCK.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_AUGMENT, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_AUGMENT.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_RAIL, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_RAIL.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_CAST_RAIL, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_CAST_RAIL.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_PLATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_PLATE.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_MANUAL, (int)0, (ModelResourceLocation)new ModelResourceLocation("minecraft:written_book", ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_PAINT_BRUSH, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_PAINT_BRUSH.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_GOLDEN_SPIKE, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_GOLDEN_SPIKE.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_RADIO_CONTROL_CARD, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_RADIO_CONTROL_CARD.getRegistryName(), ""));
        ModelLoader.setCustomModelResourceLocation((Item)IRItems.ITEM_SWITCH_KEY, (int)0, (ModelResourceLocation)new ModelResourceLocation(IRItems.ITEM_SWITCH_KEY.getRegistryName(), ""));
    }

    @SubscribeEvent
    public static void onTextureStich(TextureStitchEvent.Pre event) {
        if (ConfigGraphics.enableFlatIcons) {
            for (String defID : DefinitionManager.getDefinitionNames()) {
                EntityRollingStockDefinition def = DefinitionManager.getDefinition(defID);
                event.getMap().setTextureEntry((TextureAtlasSprite)new StockIcon(def));
            }
        }
    }

    @SubscribeEvent
    public static void afterTextureStitch(TextureStitchEvent.Post event) {
        StockRenderCache.tryPrime();
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_ROLLING_STOCK.getRegistryName(), ""), (Object)new StockItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_TRACK_BLUEPRINT.getRegistryName(), ""), (Object)new TrackBlueprintItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_ROLLING_STOCK_COMPONENT.getRegistryName(), ""), (Object)new StockItemComponentModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_AUGMENT.getRegistryName(), ""), (Object)new RailAugmentItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_RAIL.getRegistryName(), ""), (Object)new RailItemRender());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_CAST_RAIL.getRegistryName(), ""), (Object)new RailCastItemRender());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRItems.ITEM_PLATE.getRegistryName(), ""), (Object)new PlateItemModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRBlocks.BLOCK_RAIL.getRegistryName(), ""), (Object)new RailBaseModel());
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(IRBlocks.BLOCK_RAIL_GAG.getRegistryName(), ""), (Object)new RailBaseModel());
    }

    @SubscribeEvent
    public static void onKeyInput(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (!player.func_184218_aH()) {
            return;
        }
        if (!(player.func_184187_bx() instanceof EntityRidableRollingStock)) {
            return;
        }
        EntityRidableRollingStock riding = (EntityRidableRollingStock)player.func_184187_bx();
        for (KeyTypes key : keys.keySet()) {
            KeyBinding binding = keys.get((Object)key);
            if (!binding.func_151470_d()) continue;
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(key, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y(), player.func_70051_ag()));
        }
        if (player.field_71158_b.field_187257_e) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_LEFT, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y(), player.func_70051_ag()));
        }
        if (player.field_71158_b.field_187258_f) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_RIGHT, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y(), player.func_70051_ag()));
        }
        if (player.field_71158_b.field_187255_c) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_FORWARD, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y(), player.func_70051_ag()));
        }
        if (player.field_71158_b.field_187256_d) {
            ImmersiveRailroading.net.sendToServer((IMessage)new KeyPressPacket(KeyTypes.PLAYER_BACKWARD, riding.func_130014_f_().field_73011_w.getDimension(), player.func_145782_y(), riding.func_145782_y(), player.func_70051_ag()));
        }
    }

    @SubscribeEvent
    public static void onClick(MouseEvent event) {
        int attackID = Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151463_i() + 100;
        int useID = Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151463_i() + 100;
        if ((event.getButton() == attackID || event.getButton() == useID) && event.isButtonstate()) {
            if (Minecraft.func_71410_x().field_71476_x == null) {
                return;
            }
            int button = attackID == event.getButton() ? 0 : 1;
            Entity entity = Minecraft.func_71410_x().field_71476_x.field_72308_g;
            if (entity != null && entity instanceof EntityRidableRollingStock) {
                ImmersiveRailroading.net.sendToServer((IMessage)new MousePressPacket(button, entity.field_70170_p.field_73011_w.getDimension(), entity.func_145782_y()));
                event.setCanceled(true);
                return;
            }
            Entity riding = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
            if (riding != null && riding instanceof EntityRidableRollingStock) {
                ImmersiveRailroading.net.sendToServer((IMessage)new MousePressPacket(button, riding.field_70170_p.field_73011_w.getDimension(), riding.func_145782_y()));
                event.setCanceled(true);
                return;
            }
        }
    }

    @Override
    public List<InputStream> getResourceStreamAll(ResourceLocation modelLoc) throws IOException {
        ArrayList<InputStream> res = new ArrayList<InputStream>();
        try {
            for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(modelLoc)) {
                res.add(resource.func_110527_b());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        res.addAll(this.getFileResourceStreams(modelLoc));
        return res;
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        EntityRollingStock stock;
        String defID;
        EntityRollingStockDefinition def;
        if (event.getEntity() instanceof EntityRollingStock && (def = DefinitionManager.getDefinition(defID = (stock = (EntityRollingStock)event.getEntity()).getDefinitionID())) == null) {
            String error = String.format("Missing definition %s, do you have all of the required resource packs?", defID);
            ImmersiveRailroading.error(error, new Object[0]);
            event.setCanceled(true);
            if (!Minecraft.func_71410_x().func_71356_B()) {
                missingResources = error;
            }
        }
    }

    @SubscribeEvent
    public static void onHackRenderEvent(RenderWorldLastEvent event) {
        if (!ConfigGraphics.useShaderFriendlyRender) {
            float partialTicks = event.getPartialTicks();
            GLBoolTracker color = new GLBoolTracker(2903, true);
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179141_d();
            RenderOverride.renderTiles(partialTicks);
            RenderOverride.renderStock(partialTicks);
            RenderOverride.renderParticles(partialTicks);
            GlStateManager.func_179118_c();
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            RenderHelper.func_74518_a();
            color.restore();
        }
        renderCacheLimiter.reset();
    }

    @SubscribeEvent
    public static void onOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            new SteamLocomotiveOverlay().draw();
            new DieselLocomotiveOverlay().draw();
            new HandCarOverlay().draw();
        }
    }

    @SubscribeEvent
    public static void onRenderMouseover(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = event.getPlayer().func_184614_ca();
        BlockPos pos = event.getTarget().func_178782_a();
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            if (stack.func_77973_b() == IRItems.ITEM_TRACK_BLUEPRINT) {
                Vec3d vec = event.getTarget().field_72307_f;
                float hitX = (float)(vec.field_72450_a - (double)pos.func_177958_n());
                float hitY = (float)(vec.field_72448_b - (double)pos.func_177956_o());
                float hitZ = (float)(vec.field_72449_c - (double)pos.func_177952_p());
                if (BlockUtil.canBeReplaced(world, (pos = pos.func_177984_a()).func_177977_b(), true) && (!BlockUtil.isIRRail(world, pos.func_177977_b()) || (double)TileRailBase.get((IBlockAccess)world, pos.func_177977_b()).getRailHeight() < 0.5)) {
                    pos = pos.func_177977_b();
                }
                RailInfo info = new RailInfo(player.field_70170_p, stack, new PlacementInfo(stack, player.func_70079_am(), pos, hitX, hitY, hitZ), null);
                String key = info.uniqueID + info.placementInfo.placementPosition;
                RailInfo cached = infoCache.get(key);
                if (cached != null) {
                    info = cached;
                } else {
                    infoCache.put(key, info);
                }
                GL11.glPushMatrix();
                GLBoolTracker blend = new GLBoolTracker(3042, true);
                GL11.glBlendFunc((int)32771, (int)1);
                if (GLContext.getCapabilities().OpenGL14) {
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
                Vec3d cameraPos = RenderOverride.getCameraPos(event.getPartialTicks());
                Vec3d offPos = info.placementInfo.placementPosition.func_178788_d(cameraPos);
                GL11.glTranslated((double)offPos.field_72450_a, (double)offPos.field_72448_b, (double)offPos.field_72449_c);
                RailRenderUtil.render(info, true);
                blend.restore();
                GL11.glPopMatrix();
            }
            if (stack.func_77973_b() == IRItems.ITEM_MANUAL) {
                pos = pos.func_177984_a();
                GL11.glPushMatrix();
                GLBoolTracker blend = new GLBoolTracker(3042, true);
                GL11.glBlendFunc((int)32771, (int)1);
                if (GLContext.getCapabilities().OpenGL14) {
                    GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                }
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                GL11.glTranslated((double)((double)pos.func_177958_n() - d0 + 0.5), (double)((double)pos.func_177956_o() - d1 + 0.5), (double)((double)pos.func_177952_p() - d2 + 0.5));
                GL11.glRotated((double)(-((int)(((player.func_70079_am() % 360.0f + 360.0f) % 360.0f + 45.0f) / 90.0f)) * 90), (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                MBBlueprintRender.draw(player.func_130014_f_(), ItemMultiblockType.get(stack));
                blend.restore();
                GL11.glPopMatrix();
            }
        }
    }

    @SubscribeEvent
    public static void onDebugRender(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && GPUInfo.hasGPUInfo()) {
            int i;
            for (i = 0; i < event.getRight().size(); ++i) {
                if (!((String)event.getRight().get(i)).startsWith("Display: ")) continue;
                ++i;
                break;
            }
            event.getRight().add(i, GPUInfo.debug());
        }
    }

    @SubscribeEvent
    public static void onSoundLoad(SoundLoadEvent event) {
        if (manager == null) {
            manager = new IRSoundManager(event.getManager());
        } else {
            manager.handleReload(false);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        manager.handleReload(true);
        if (sndCache == null) {
            sndCache = new ArrayList<ISound>();
            for (int i = 0; i < 16; ++i) {
                sndCache.add(ImmersiveRailroading.proxy.newSound(new ResourceLocation("immersiverailroading", "sounds/default/clack.ogg"), false, 30.0f, Gauge.from(1.435)));
            }
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
    }

    @SubscribeEvent
    public static void onEnterChunk(EntityEvent.EnteringChunk event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!ConfigSound.soundEnabled) {
            return;
        }
        if (sndCache != null && event.getEntity() instanceof EntityMoveableRollingStock) {
            if (event.getNewChunkX() == event.getOldChunkX() && event.getNewChunkZ() % 8 != 0) {
                return;
            }
            if (event.getNewChunkZ() == event.getOldChunkZ() && event.getNewChunkX() % 8 != 0) {
                return;
            }
            ISound snd = sndCache.get(sndCacheId);
            EntityMoveableRollingStock stock = (EntityMoveableRollingStock)event.getEntity();
            float adjust = (float)Math.abs(stock.getCurrentSpeed().metric()) / 300.0f;
            if (stock.getDefinition().shouldScalePitch()) {
                snd.setPitch((float)(((double)adjust + 0.7) / stock.gauge.scale()));
            } else {
                snd.setPitch((float)((double)adjust + 0.7));
            }
            snd.setVolume(0.01f + adjust);
            snd.play(event.getEntity().func_174791_d());
            ++sndCacheId;
            sndCacheId %= sndCache.size();
        }
    }

    @Override
    public ISound newSound(ResourceLocation oggLocation, boolean repeats, float attenuationDistance, Gauge gauge) {
        return manager.createSound(oggLocation, repeats, attenuationDistance, gauge);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientProxy.dampenSound();
        if (missingResources != null) {
            Minecraft.func_71410_x().func_147114_u().func_147298_b().func_150718_a((ITextComponent)new TextComponentString(missingResources));
            Minecraft.func_71410_x().func_71403_a((WorldClient)null);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDisconnected((GuiScreen)new GuiMultiplayer((GuiScreen)new GuiMainMenu()), "disconnect.lost", (ITextComponent)new TextComponentString(missingResources)));
            missingResources = null;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = null;
        if (player != null) {
            world = player.field_70170_p;
        }
        if (world == null && manager != null && manager.hasSounds()) {
            ImmersiveRailroading.warn("Unloading IR sound system", new Object[0]);
            manager.stop();
            sndCache = null;
        }
        if (world != null) {
            if (magical == null) {
                magical = new MagicEntity(world);
                world.func_72838_d((Entity)magical);
            }
            if (magical != null) {
                magical.func_70071_h_();
                if (ClientProxy.magical.field_70128_L) {
                    ClientProxy.magical.field_70128_L = false;
                    ImmersiveRailroading.warn("Reanimating magic entity", new Object[0]);
                    ClientProxy.magical.field_70170_p.func_72838_d((Entity)magical);
                }
                if (tickCount % 20 == 0 && !world.field_72996_f.contains((Object)magical)) {
                    ImmersiveRailroading.warn("Respawning magic entity", new Object[0]);
                    ClientProxy.magical.field_70170_p.func_72900_e((Entity)magical);
                    ClientProxy.magical.field_70128_L = false;
                    world.func_72838_d((Entity)magical);
                }
            }
        }
        ++tickCount;
        manager.tick();
    }

    @Override
    public int getTicks() {
        return tickCount;
    }

    @Override
    public int getRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    @Override
    public void addPreview(int dimension, TileRailPreview preview) {
        ExpireableList<BlockPos, TileRailPreview> pvs;
        TileRailPreview curr;
        if (!previews.containsKey(dimension)) {
            previews.put(dimension, new ExpireableList<BlockPos, TileRailPreview>(){

                @Override
                public int lifespan() {
                    return 2;
                }

                @Override
                public boolean sliding() {
                    return false;
                }
            });
        }
        if ((curr = (pvs = previews.get(dimension)).get(preview.func_174877_v())) != null && curr.func_189515_b(new NBTTagCompound()).equals((Object)preview.func_189515_b(new NBTTagCompound()))) {
            preview = curr;
        }
        previews.get(dimension).put(preview.func_174877_v(), preview);
    }

    public Collection<TileRailPreview> getPreviews() {
        ExpireableList<BlockPos, TileRailPreview> pvs = previews.get(Minecraft.func_71410_x().field_71439_g.field_71093_bK);
        if (pvs != null) {
            return pvs.values();
        }
        return null;
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("immersiverailroading")) {
            ConfigManager.sync((String)"immersiverailroading", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        renderCacheLimiter = new RenderCacheTimeLimiter();
        dampeningAmount = 1.0f;
        RENDER_INSTANCE = new IRenderFactory<EntityRollingStock>(){

            public Render<? super EntityRollingStock> createRenderFor(RenderManager manager) {
                return new StockEntityRender(manager);
            }
        };
        PARTICLE_RENDER = new IRenderFactory<EntitySmokeParticle>(){

            public Render<? super EntitySmokeParticle> createRenderFor(RenderManager manager) {
                return new ParticleRender(manager);
            }
        };
        MAGIC_RENDER = new IRenderFactory<MagicEntity>(){

            public Render<? super MagicEntity> createRenderFor(RenderManager manager) {
                return new MagicEntityRender(manager);
            }
        };
        cachedIcons = new HashMap<String, BufferedImage>();
        sndCacheId = 0;
        tickCount = 0;
    }

    public static final class StockIcon
    extends TextureAtlasSprite {
        private EntityRollingStockDefinition def;

        public StockIcon(EntityRollingStockDefinition def) {
            super(new ResourceLocation("immersiverailroading", def.defID).toString());
            this.def = def;
            this.field_130223_c = this.field_130224_d = ConfigGraphics.flatIconSize;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            BufferedImage image;
            StockModel renderer = StockRenderCache.getRender(this.def.defID);
            if (!cachedIcons.containsKey(this.def.defID)) {
                image = new BufferedImage(this.func_94211_a(), this.func_94216_b(), 2);
                EntityRollingStockDefinition.IconPart[][] map = this.def.getIcon(this.func_94211_a());
                for (int x = 0; x < this.func_94211_a(); ++x) {
                    for (int y = 0; y < this.func_94216_b(); ++y) {
                        if (map[x][y] != null) {
                            EntityRollingStockDefinition.IconPart pt = map[x][y];
                            int color = ((OBJTextureSheet)renderer.textures.get(null)).samp(pt.mtl, pt.u, pt.v);
                            image.setRGB(x, this.func_94211_a() - (y + 1), color);
                            continue;
                        }
                        image.setRGB(x, this.func_94211_a() - (y + 1), 0);
                    }
                }
                cachedIcons.put(this.def.defID, image);
            }
            image = (BufferedImage)cachedIcons.get(this.def.defID);
            for (OBJTextureSheet tex : renderer.textures.values()) {
                tex.freePx();
            }
            int[][] pixels = new int[Minecraft.func_71410_x().field_71474_y.field_151442_I + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.func_130103_l();
            this.field_110976_a.add(pixels);
            return false;
        }
    }
}

